/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.annotation.Priority;
import org.eclipse.microprofile.config.spi.Converter;
import org.wildfly.common.net.Inet;

@Priority(value=200)
public class InetSocketAddressConverter
implements Converter<InetSocketAddress> {
    public InetSocketAddress convert(String value) {
        int portPart;
        String hostPart;
        if (value.isEmpty()) {
            return null;
        }
        int lastColon = value.lastIndexOf(58);
        int lastCloseBracket = value.lastIndexOf(93);
        if (lastColon == -1 || lastCloseBracket != -1 && lastColon < lastCloseBracket) {
            hostPart = value;
            portPart = 0;
        } else {
            hostPart = value.substring(0, lastColon);
            portPart = Integer.parseInt(value.substring(lastColon + 1));
        }
        while (hostPart.startsWith("[") && hostPart.endsWith("]")) {
            hostPart = hostPart.substring(1, hostPart.length() - 1);
        }
        if (hostPart.isEmpty()) {
            return new InetSocketAddress(portPart);
        }
        InetAddress resolved = Inet.parseInetAddress((String)hostPart);
        return resolved == null ? InetSocketAddress.createUnresolved(hostPart, portPart) : new InetSocketAddress(resolved, portPart);
    }
}

