/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.util;

import io.smallrye.config.SmallRyeConfig;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public final class ContainerRuntimeUtil {
    private static final Logger log = Logger.getLogger(ContainerRuntimeUtil.class);
    private static final String DOCKER_EXECUTABLE = ((SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class)).getOptionalValue("quarkus.native.container-runtime", String.class).orElse(null);
    static final Path CONTAINER_RUNTIME = Path.of(System.getProperty("java.io.tmpdir"), "quarkus_container_runtime.txt");

    private ContainerRuntimeUtil() {
    }

    public static ContainerRuntime detectContainerRuntime() {
        return ContainerRuntimeUtil.detectContainerRuntime(true);
    }

    public static ContainerRuntime detectContainerRuntime(boolean required) {
        ContainerRuntime containerRuntime = ContainerRuntimeUtil.loadConfig();
        if (containerRuntime != null) {
            return containerRuntime;
        }
        String dockerVersionOutput = ContainerRuntimeUtil.getVersionOutputFor(ContainerRuntime.DOCKER);
        boolean dockerAvailable = dockerVersionOutput.contains("Docker version");
        String podmanVersionOutput = ContainerRuntimeUtil.getVersionOutputFor(ContainerRuntime.PODMAN);
        boolean podmanAvailable = podmanVersionOutput.startsWith("podman version");
        if (DOCKER_EXECUTABLE != null) {
            if (DOCKER_EXECUTABLE.trim().equalsIgnoreCase("docker") && dockerAvailable) {
                ContainerRuntimeUtil.storeConfig(ContainerRuntime.DOCKER);
                return ContainerRuntime.DOCKER;
            }
            if (DOCKER_EXECUTABLE.trim().equalsIgnoreCase("podman") && podmanAvailable) {
                ContainerRuntimeUtil.storeConfig(ContainerRuntime.PODMAN);
                return ContainerRuntime.PODMAN;
            }
            log.warn((Object)"quarkus.native.container-runtime config property must be set to either podman or docker and the executable must be available. Ignoring it.");
        }
        if (dockerAvailable) {
            if (dockerVersionOutput.equals(podmanVersionOutput)) {
                ContainerRuntimeUtil.storeConfig(ContainerRuntime.PODMAN);
                return ContainerRuntime.PODMAN;
            }
            ContainerRuntimeUtil.storeConfig(ContainerRuntime.DOCKER);
            return ContainerRuntime.DOCKER;
        }
        if (podmanAvailable) {
            ContainerRuntimeUtil.storeConfig(ContainerRuntime.PODMAN);
            return ContainerRuntime.PODMAN;
        }
        if (required) {
            throw new IllegalStateException("No container runtime was found. Make sure you have either Docker or Podman installed in your environment.");
        }
        ContainerRuntimeUtil.storeConfig(ContainerRuntime.UNAVAILABLE);
        return ContainerRuntime.UNAVAILABLE;
    }

    private static ContainerRuntime loadConfig() {
        try {
            if (Files.isReadable(CONTAINER_RUNTIME)) {
                String runtime = Files.readString(CONTAINER_RUNTIME, StandardCharsets.UTF_8);
                if (ContainerRuntime.DOCKER.name().equalsIgnoreCase(runtime)) {
                    return ContainerRuntime.DOCKER;
                }
                if (ContainerRuntime.PODMAN.name().equalsIgnoreCase(runtime)) {
                    return ContainerRuntime.PODMAN;
                }
                if (ContainerRuntime.UNAVAILABLE.name().equalsIgnoreCase(runtime)) {
                    return ContainerRuntime.UNAVAILABLE;
                }
                log.warnf("The file %s contains an unknown value %s. Ignoring it.", (Object)CONTAINER_RUNTIME.toAbsolutePath(), (Object)runtime);
                return null;
            }
            return null;
        }
        catch (IOException e) {
            log.warnf("Error reading file %s. Ignoring it. See: %s", (Object)CONTAINER_RUNTIME.toAbsolutePath(), (Object)e);
            return null;
        }
    }

    private static void storeConfig(ContainerRuntime containerRuntime) {
        try {
            Files.writeString(CONTAINER_RUNTIME, (CharSequence)containerRuntime.name(), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            CONTAINER_RUNTIME.toFile().deleteOnExit();
        }
        catch (IOException e) {
            log.warnf("Error writing to file %s. Ignoring it. See: %s", (Object)CONTAINER_RUNTIME.toAbsolutePath(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getVersionOutputFor(ContainerRuntime containerRuntime) {
        Process versionProcess = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(containerRuntime.getExecutableName(), "--version").redirectErrorStream(true);
            versionProcess = pb.start();
            versionProcess.waitFor();
            String string = new String(versionProcess.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException | InterruptedException e) {
            log.debugf((Throwable)e, "Failure to read version output from %s", (Object)containerRuntime.getExecutableName());
            String string = "";
            return string;
        }
        finally {
            if (versionProcess != null) {
                versionProcess.destroy();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static boolean getRootlessStateFor(ContainerRuntime containerRuntime) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ boolean lambda$getRootlessStateFor$1(String line) {
        return line.trim().equals("rootless: true");
    }

    private static /* synthetic */ boolean lambda$getRootlessStateFor$0(String line) {
        return line.trim().equals("rootless");
    }

    public static enum ContainerRuntime {
        DOCKER,
        PODMAN,
        UNAVAILABLE;

        private Boolean rootless;

        public String getExecutableName() {
            return this.name().toLowerCase();
        }

        public boolean isRootless() {
            if (this.rootless != null) {
                return this.rootless;
            }
            if (this == UNAVAILABLE) {
                throw new IllegalStateException("No container runtime was found. Make sure you have either Docker or Podman installed in your environment.");
            }
            this.rootless = ContainerRuntimeUtil.getRootlessStateFor(this);
            return this.rootless;
        }
    }
}

