/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.ImageMode;
import io.quarkus.runtime.configuration.NameIterator;
import io.smallrye.config.common.utils.StringUtil;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public final class ConfigDiagnostic {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.config");
    private static final List<String> errorsMessages = new CopyOnWriteArrayList<String>();
    private static final Set<String> errorKeys = new CopyOnWriteArraySet<String>();

    private ConfigDiagnostic() {
    }

    public static void invalidValue(String name, IllegalArgumentException ex) {
        String message = ex.getMessage();
        String loggedMessage = message != null ? message : String.format("An invalid value was given for configuration key \"%s\"", name);
        errorsMessages.add(loggedMessage);
        errorKeys.add(name);
    }

    public static void missingValue(String name, NoSuchElementException ex) {
        String message = ex.getMessage();
        String loggedMessage = message != null ? message : String.format("Configuration key \"%s\" is required, but its value is empty/missing", name);
        errorsMessages.add(loggedMessage);
        errorKeys.add(name);
    }

    public static void duplicate(String name) {
        String loggedMessage = String.format("Configuration key \"%s\" was specified more than once", name);
        errorsMessages.add(loggedMessage);
        errorKeys.add(name);
    }

    public static void deprecated(String name) {
        log.warnf("Configuration key \"%s\" is deprecated", (Object)name);
    }

    public static void unknown(String name) {
        log.warnf("Unrecognized configuration key \"%s\" was provided; it will be ignored; verify that the dependency extension for this configuration is set or that you did not make a typo", (Object)name);
    }

    public static void unknown(NameIterator name) {
        ConfigDiagnostic.unknown(name.getName());
    }

    public static void unknownProperties(Set<String> properties) {
        HashSet<String> usedProperties = new HashSet<String>();
        for (String property : ConfigProvider.getConfig().getPropertyNames()) {
            if (properties.contains(property)) continue;
            usedProperties.add(StringUtil.replaceNonAlphanumericByUnderscores((String)property));
        }
        usedProperties.removeAll(properties);
        for (String property : properties) {
            if (property.contains("[") && property.contains("]")) continue;
            boolean found = false;
            for (String usedProperty : usedProperties) {
                if (!usedProperty.equalsIgnoreCase(StringUtil.replaceNonAlphanumericByUnderscores((String)property))) continue;
                found = true;
                break;
            }
            if (found) continue;
            ConfigDiagnostic.unknown(property);
        }
    }

    public static void unknownRunTime(String name) {
        if (ImageMode.current() == ImageMode.NATIVE_RUN) {
            ConfigDiagnostic.unknown(name);
        }
    }

    public static void unknownRunTime(NameIterator name) {
        ConfigDiagnostic.unknownRunTime(name.getName());
    }

    public static void unknownPropertiesRuntime(Set<String> properties) {
        if (ImageMode.current() == ImageMode.NATIVE_RUN) {
            ConfigDiagnostic.unknownProperties(properties);
        }
    }

    public static boolean isError() {
        return !errorsMessages.isEmpty();
    }

    public static void resetError() {
        errorKeys.clear();
        errorsMessages.clear();
    }

    public static String getNiceErrorMessage() {
        StringBuilder b = new StringBuilder();
        for (String errorsMessage : errorsMessages) {
            b.append("  - ");
            b.append(errorsMessage);
            b.append(System.lineSeparator());
        }
        return b.toString();
    }

    public static Set<String> getErrorKeys() {
        return new HashSet<String>(errorKeys);
    }
}

