/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.init;

import io.quarkus.runtime.PreventFurtherStepsException;
import io.quarkus.runtime.Quarkus;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.init.InitRuntimeConfig;
import io.smallrye.config.common.utils.StringUtil;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.ConfigProvider;

@Recorder
public class InitializationTaskRecorder {
    private static final String QUARKUS_INIT_AND_EXIT = "quarkus.init-and-exit";
    private final RuntimeValue<InitRuntimeConfig> config;

    public InitializationTaskRecorder(RuntimeValue<InitRuntimeConfig> config) {
        this.config = config;
    }

    public void exitIfNeeded() {
        boolean initAndExitConfigured = InitializationTaskRecorder.propertyConfigured(QUARKUS_INIT_AND_EXIT);
        if (initAndExitConfigured && this.config.getValue().initAndExit && ((Boolean)ConfigProvider.getConfig().getValue(QUARKUS_INIT_AND_EXIT, Boolean.TYPE)).booleanValue()) {
            InitializationTaskRecorder.preventFurtherRecorderSteps(5, "Error attempting to gracefully shutdown after initialization", () -> new PreventFurtherStepsException("Gracefully exiting after initialization.", 0));
        }
    }

    public static void preventFurtherRecorderSteps(int waitSeconds, String waitErrorMessage, Supplier<PreventFurtherStepsException> supplier) {
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(new Runnable(){

            @Override
            public void run() {
                Quarkus.blockingExit();
                latch.countDown();
            }
        }).start();
        try {
            latch.await(waitSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            System.err.println(waitErrorMessage);
        }
        throw supplier.get();
    }

    private static String propertyToEnvVar(String property) {
        return StringUtil.replaceNonAlphanumericByUnderscores((String)property).toUpperCase();
    }

    private static boolean propertyConfigured(String property) {
        return StreamSupport.stream(ConfigProvider.getConfig().getPropertyNames().spliterator(), false).anyMatch(n -> property.equals(n) || InitializationTaskRecorder.propertyToEnvVar(property).equals(n));
    }
}

