/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.creator.demo;

import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.bootstrap.util.PropertyUtils;
import io.quarkus.creator.AppCreator;
import io.quarkus.creator.phase.augment.AugmentPhase;
import io.quarkus.creator.phase.curate.CuratePhase;
import io.quarkus.creator.phase.nativeimage.NativeImageOutcome;
import io.quarkus.creator.phase.nativeimage.NativeImagePhase;
import io.quarkus.creator.phase.runnerjar.RunnerJarOutcome;
import io.quarkus.creator.phase.runnerjar.RunnerJarPhase;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class AppCreatorDemo {
    public static void main(String[] args) throws Exception {
        Path quarkusRoot = Paths.get("", new String[0]).toAbsolutePath().getParent().getParent();
        Path exampleTarget = quarkusRoot.resolve("integration-tests").resolve("bean-validation-strict").resolve("target");
        Path appJar = exampleTarget.resolve("quarkus-integration-test-bean-validation-999-SNAPSHOT.jar");
        if (!Files.exists(appJar, new LinkOption[0])) {
            throw new Exception("Failed to locate user app " + appJar);
        }
        Path demoDir = Paths.get(PropertyUtils.getUserHome(), new String[0]).resolve("quarkus-creator-demo");
        IoUtils.recursiveDelete((Path)demoDir);
        AppCreatorDemo.buildRunnableJar(appJar, demoDir);
    }

    private static void buildRunnableJar(Path userApp, Path outputDir) throws Exception {
        RunnerJarOutcome runnerJar;
        try (AppCreator appCreator = AppCreator.builder().addPhase(new CuratePhase()).addPhase(new AugmentPhase()).addPhase(new RunnerJarPhase()).addPhase(new NativeImagePhase()).setAppJar(userApp).build();){
            runnerJar = appCreator.resolveOutcome(RunnerJarOutcome.class);
            System.out.println("Runner JAR: " + runnerJar.getRunnerJar() + " exists=" + Files.exists(runnerJar.getRunnerJar(), new LinkOption[0]));
        }
        System.out.println("Runner JAR: " + runnerJar.getRunnerJar() + " exists=" + Files.exists(runnerJar.getRunnerJar(), new LinkOption[0]));
    }

    private static void buildNativeImage(Path userApp, Path outputDir) throws Exception {
        try (AppCreator appCreator = AppCreator.builder().addPhase(new CuratePhase()).addPhase(new AugmentPhase()).addPhase(new RunnerJarPhase()).addPhase(new NativeImagePhase().setOutputDir(outputDir)).setAppJar(userApp).build();){
            appCreator.resolveOutcome(NativeImageOutcome.class);
        }
    }

    private static void logLibDiff(Path exampleTarget, Path testBuildDir) throws IOException {
        Set<String> originalNames = AppCreatorDemo.readNames(exampleTarget.resolve("lib"));
        Set<String> aetherNames = AppCreatorDemo.readNames(testBuildDir.resolve("lib"));
        HashSet<String> originalOnly = new HashSet<String>(originalNames);
        originalOnly.removeAll(aetherNames);
        AppCreatorDemo.logNames("Original build lib jars not found in the test lib:", originalOnly);
        HashSet<String> aetherOnly = new HashSet<String>(aetherNames);
        aetherOnly.removeAll(originalNames);
        AppCreatorDemo.logNames("Test lib jars not found in the original build lib:", aetherOnly);
    }

    private static void logNames(String header, Set<String> names) {
        if (names.isEmpty()) {
            return;
        }
        System.out.println(header);
        ArrayList<String> sorted = new ArrayList<String>(names);
        Collections.sort(sorted);
        for (int i = 0; i < sorted.size(); ++i) {
            System.out.println(i + 1 + ") " + (String)sorted.get(i));
        }
    }

    private static Set<String> readNames(Path path) throws IOException {
        HashSet<String> names = new HashSet<String>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
            for (Path p : stream) {
                names.add(p.getFileName().toString());
            }
        }
        return names;
    }
}

