/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.creator.demo;

import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.creator.AppCreator;
import io.quarkus.creator.demo.ConfigDemoBase;
import io.quarkus.creator.phase.curate.CurateOutcome;
import io.quarkus.creator.phase.curate.CuratePhase;
import io.quarkus.creator.phase.curate.VersionUpdate;
import io.quarkus.creator.phase.curate.VersionUpdateNumber;
import java.util.Properties;

public class CheckUpdatesDemo
extends ConfigDemoBase {
    public static void main(String[] args) throws Exception {
        new CheckUpdatesDemo().run();
    }

    @Override
    protected void initProps(Properties props) {
        props.setProperty(CuratePhase.completePropertyName("version-update"), VersionUpdate.NONE.getName());
        props.setProperty(CuratePhase.completePropertyName("version-update-number"), VersionUpdateNumber.MINOR.getName());
    }

    @Override
    protected boolean isLogLibDiff() {
        return false;
    }

    @Override
    public void demo(AppCreator creator) throws Exception {
        CurateOutcome curate = creator.resolveOutcome(CurateOutcome.class);
        boolean updatesAvailable = curate.hasUpdatedDeps();
        System.out.println("Updates available: " + updatesAvailable);
        if (!updatesAvailable) {
            return;
        }
        System.out.println("Available updates:");
        for (AppDependency dep : curate.getUpdatedDeps()) {
            System.out.println("- " + dep);
        }
    }
}

