/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.creator.demo;

import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.bootstrap.util.PropertyUtils;
import io.quarkus.creator.AppCreator;
import io.quarkus.creator.config.reader.PropertiesConfigReader;
import io.quarkus.creator.config.reader.PropertiesHandler;
import io.quarkus.creator.phase.curate.CuratePhase;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class ConfigDemoBase {
    protected Path appJar;
    protected Path workDir;

    public void run() throws Exception {
        Path appJar = this.getAppJar();
        if (!Files.exists(appJar, new LinkOption[0])) {
            throw new IllegalStateException("Failed to locate user app " + appJar);
        }
        Path demoDir = this.getDemoWorkDir();
        IoUtils.recursiveDelete((Path)demoDir);
        Properties props = this.getProperties();
        Files.createDirectories(demoDir, new FileAttribute[0]);
        Path propsFile = demoDir.resolve("app-creator.properties");
        try (OutputStream out = Files.newOutputStream(propsFile, new OpenOption[0]);){
            props.store(out, "Example AppCreator properties");
        }
        PropertiesHandler<AppCreator> propsHandler = AppCreator.builder().setAppJar(appJar).getPropertiesHandler();
        try (AppCreator appCreator = PropertiesConfigReader.getInstance(propsHandler).read(propsFile);){
            this.demo(appCreator);
            if (this.isLogLibDiff()) {
                ConfigDemoBase.logLibDiff(appJar.getParent(), demoDir);
            }
        }
    }

    protected void demo(AppCreator creator) throws Exception {
    }

    protected boolean isLogLibDiff() {
        return false;
    }

    protected Path initAppJar() {
        Path quarkusRoot = Paths.get("", new String[0]).toAbsolutePath().getParent().getParent();
        Path quickstartsRoot = quarkusRoot.getParent().resolve("quarkus-quickstarts");
        if (!Files.exists(quickstartsRoot, new LinkOption[0])) {
            throw new IllegalStateException("Failed to locate quarkus-quickstarts repo at " + quickstartsRoot);
        }
        Path appDir = quickstartsRoot.resolve("application-configuration").resolve("target");
        Path appJar = appDir.resolve("application-configuration-1.0-SNAPSHOT.jar");
        return appJar;
    }

    public Path getAppJar() {
        return this.appJar == null ? (this.appJar = this.initAppJar()) : this.appJar;
    }

    public Path getDemoWorkDir() {
        return this.workDir == null ? (this.workDir = Paths.get(PropertyUtils.getUserHome(), new String[0]).resolve("quarkus-creator-demo")) : this.workDir;
    }

    public Properties getProperties() {
        Properties props = new Properties();
        Path demoDir = this.getDemoWorkDir();
        if (demoDir != null) {
            props.setProperty("output", demoDir.toString());
        }
        props.setProperty(CuratePhase.completePropertyName("local-repo"), Paths.get(PropertyUtils.getUserHome(), "quarkus-curate-repo").toString());
        this.initProps(props);
        return props;
    }

    protected void initProps(Properties props) {
    }

    private static void logLibDiff(Path exampleTarget, Path testBuildDir) throws IOException {
        Set<String> originalNames = ConfigDemoBase.readNames(exampleTarget.resolve("lib"));
        Set<String> aetherNames = ConfigDemoBase.readNames(testBuildDir.resolve("lib"));
        HashSet<String> originalOnly = new HashSet<String>(originalNames);
        originalOnly.removeAll(aetherNames);
        ConfigDemoBase.logNames("Original build lib jars not found in the test lib:", originalOnly);
        HashSet<String> aetherOnly = new HashSet<String>(aetherNames);
        aetherOnly.removeAll(originalNames);
        ConfigDemoBase.logNames("Test lib jars not found in the original build lib:", aetherOnly);
    }

    private static void logNames(String header, Set<String> names) {
        if (names.isEmpty()) {
            return;
        }
        System.out.println(header);
        ArrayList<String> sorted = new ArrayList<String>(names);
        Collections.sort(sorted);
        for (int i = 0; i < sorted.size(); ++i) {
            System.out.println(i + 1 + ") " + (String)sorted.get(i));
        }
    }

    private static Set<String> readNames(Path path) throws IOException {
        HashSet<String> names = new HashSet<String>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
            for (Path p : stream) {
                names.add(p.getFileName().toString());
            }
        }
        return names;
    }
}

