/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.creator.phase.augment;

import io.quarkus.bootstrap.BootstrapDependencyProcessingException;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.bootstrap.util.ZipUtils;
import io.quarkus.creator.AppCreationPhase;
import io.quarkus.creator.AppCreator;
import io.quarkus.creator.AppCreatorException;
import io.quarkus.creator.config.reader.MappedPropertiesHandler;
import io.quarkus.creator.config.reader.PropertiesHandler;
import io.quarkus.creator.outcome.OutcomeProviderRegistration;
import io.quarkus.creator.phase.augment.AugmentOutcome;
import io.quarkus.creator.phase.curate.CurateOutcome;
import io.quarkus.deployment.ApplicationInfoUtil;
import io.quarkus.deployment.ClassOutput;
import io.quarkus.deployment.QuarkusAugmentor;
import io.quarkus.deployment.QuarkusClassWriter;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateOutputBuildItem;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.builder.BuildResult;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class AugmentPhase
implements AppCreationPhase<AugmentPhase>,
AugmentOutcome {
    private static final Logger log = Logger.getLogger(AugmentPhase.class);
    private static final String APPLICATION_INFO_PROPERTIES = "application-info.properties";
    private static final String META_INF = "META-INF";
    private Path outputDir;
    private Path appClassesDir;
    private Path transformedClassesDir;
    private Path wiringClassesDir;
    private Path configDir;

    public AugmentPhase setOutputDir(Path outputDir) {
        this.outputDir = outputDir;
        return this;
    }

    public AugmentPhase setAppClassesDir(Path appClassesDir) {
        this.appClassesDir = appClassesDir;
        return this;
    }

    public AugmentPhase setTransformedClassesDir(Path transformedClassesDir) {
        this.transformedClassesDir = transformedClassesDir;
        return this;
    }

    public AugmentPhase setWiringClassesDir(Path wiringClassesDir) {
        this.wiringClassesDir = wiringClassesDir;
        return this;
    }

    public AugmentPhase setConfigDir(Path configDir) {
        this.configDir = configDir;
        return this;
    }

    @Override
    public Path getAppClassesDir() {
        return this.appClassesDir;
    }

    @Override
    public Path getTransformedClassesDir() {
        return this.transformedClassesDir;
    }

    @Override
    public Path getWiringClassesDir() {
        return this.wiringClassesDir;
    }

    @Override
    public Path getConfigDir() {
        return this.configDir;
    }

    @Override
    public void register(OutcomeProviderRegistration registration) throws AppCreatorException {
        registration.provides(AugmentOutcome.class);
    }

    @Override
    public void provideOutcome(AppCreator ctx) throws AppCreatorException {
        CurateOutcome appState = ctx.resolveOutcome(CurateOutcome.class);
        Path path = this.outputDir = this.outputDir == null ? ctx.getWorkPath(new String[0]) : IoUtils.mkdirs((Path)this.outputDir);
        if (this.appClassesDir == null) {
            this.appClassesDir = this.outputDir.resolve("classes");
            Path appJar = appState.getAppArtifact().getPath();
            try {
                ZipUtils.unzip((Path)appJar, (Path)this.appClassesDir);
            }
            catch (IOException e) {
                throw new AppCreatorException("Failed to unzip " + appJar, e);
            }
            Path metaInf = this.appClassesDir.resolve(META_INF);
            IoUtils.recursiveDelete((Path)metaInf.resolve("maven"));
            IoUtils.recursiveDelete((Path)metaInf.resolve("INDEX.LIST"));
            IoUtils.recursiveDelete((Path)metaInf.resolve("MANIFEST.MF"));
            IoUtils.recursiveDelete((Path)metaInf.resolve(APPLICATION_INFO_PROPERTIES));
        }
        ApplicationInfoUtil.writeApplicationInfoProperties((AppArtifact)appState.getAppArtifact(), (Path)this.appClassesDir);
        if (this.configDir == null) {
            this.configDir = this.appClassesDir;
        }
        this.transformedClassesDir = IoUtils.mkdirs((Path)(this.transformedClassesDir == null ? this.outputDir.resolve("transformed-classes") : this.transformedClassesDir));
        this.wiringClassesDir = IoUtils.mkdirs((Path)(this.wiringClassesDir == null ? this.outputDir.resolve("wiring-classes") : this.wiringClassesDir));
        this.doProcess(appState);
        ctx.pushOutcome(AugmentOutcome.class, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcess(CurateOutcome appState) throws AppCreatorException {
        block36: {
            List appDeps;
            Path config = this.configDir.resolve("application.properties");
            if (Files.exists(config, new LinkOption[0])) {
                try {
                    Config built = SmallRyeConfigProviderResolver.instance().getBuilder().addDefaultSources().addDiscoveredConverters().addDiscoveredSources().withSources(new ConfigSource[]{new PropertiesConfigSource(config.toUri().toURL())}).build();
                    SmallRyeConfigProviderResolver.instance().registerConfig(built, Thread.currentThread().getContextClassLoader());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            AppModelResolver depResolver = appState.getArtifactResolver();
            try {
                appDeps = appState.getEffectiveModel().getAllDependencies();
            }
            catch (BootstrapDependencyProcessingException e) {
                throw new AppCreatorException("Failed to resolve application build classpath", e);
            }
            URLClassLoader runnerClassLoader = null;
            try {
                BuildResult result;
                ArrayList<URL> cpUrls = new ArrayList<URL>(appDeps.size() + 1);
                cpUrls.add(this.appClassesDir.toUri().toURL());
                for (AppDependency appDep : appDeps) {
                    Path resolvedDep = depResolver.resolve(appDep.getArtifact());
                    cpUrls.add(resolvedDep.toUri().toURL());
                }
                runnerClassLoader = new URLClassLoader(cpUrls.toArray(new URL[cpUrls.size()]), this.getClass().getClassLoader());
                final Path wiringClassesDirectory = this.wiringClassesDir;
                ClassOutput classOutput = new ClassOutput(){

                    public void writeClass(boolean applicationClass, String className, byte[] data) throws IOException {
                        String location = className.replace('.', '/');
                        Path p = wiringClassesDirectory.resolve(location + ".class");
                        Files.createDirectories(p.getParent(), new FileAttribute[0]);
                        try (OutputStream out = Files.newOutputStream(p, new OpenOption[0]);){
                            out.write(data);
                        }
                    }

                    public void writeResource(String name, byte[] data) throws IOException {
                        Path p = wiringClassesDirectory.resolve(name);
                        Files.createDirectories(p.getParent(), new FileAttribute[0]);
                        try (OutputStream out = Files.newOutputStream(p, new OpenOption[0]);){
                            out.write(data);
                        }
                    }
                };
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(runnerClassLoader);
                    QuarkusAugmentor.Builder builder = QuarkusAugmentor.builder();
                    builder.setRoot(this.appClassesDir);
                    builder.setClassLoader((ClassLoader)runnerClassLoader);
                    builder.setOutput(classOutput);
                    builder.addFinal(BytecodeTransformerBuildItem.class).addFinal(MainClassBuildItem.class).addFinal(SubstrateOutputBuildItem.class);
                    result = builder.build().run();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
                List bytecodeTransformerBuildItems = result.consumeMulti(BytecodeTransformerBuildItem.class);
                if (bytecodeTransformerBuildItems.isEmpty()) break block36;
                final HashMap<String, List> bytecodeTransformers = new HashMap<String, List>(bytecodeTransformerBuildItems.size());
                if (!bytecodeTransformerBuildItems.isEmpty()) {
                    for (BytecodeTransformerBuildItem i : bytecodeTransformerBuildItems) {
                        bytecodeTransformers.computeIfAbsent(i.getClassToTransform(), h -> new ArrayList()).add(i.getVisitorFunction());
                    }
                }
                final ExecutorService executorPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
                final ConcurrentLinkedDeque transformed = new ConcurrentLinkedDeque();
                try {
                    final URLClassLoader transformCl = runnerClassLoader;
                    Files.walk(this.appClassesDir, new FileVisitOption[0]).forEach(new Consumer<Path>(){

                        @Override
                        public void accept(final Path path) {
                            if (Files.isDirectory(path, new LinkOption[0])) {
                                return;
                            }
                            final String pathName = AugmentPhase.this.appClassesDir.relativize(path).toString();
                            if (!pathName.endsWith(".class") || bytecodeTransformers.isEmpty()) {
                                return;
                            }
                            final String className = pathName.substring(0, pathName.length() - 6).replace('/', '.');
                            final List visitors = (List)bytecodeTransformers.get(className);
                            if (visitors == null || visitors.isEmpty()) {
                                return;
                            }
                            transformed.add(executorPool.submit(new Callable<FutureEntry>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public FutureEntry call() throws Exception {
                                    ClassLoader old = Thread.currentThread().getContextClassLoader();
                                    try {
                                        QuarkusClassWriter writer;
                                        Thread.currentThread().setContextClassLoader(transformCl);
                                        if (Files.size(path) > Integer.MAX_VALUE) {
                                            throw new RuntimeException("Can't process class files larger than Integer.MAX_VALUE bytes");
                                        }
                                        ClassReader cr = new ClassReader(Files.readAllBytes(path));
                                        QuarkusClassWriter visitor = writer = new QuarkusClassWriter(cr, 3);
                                        for (BiFunction i : visitors) {
                                            visitor = (ClassVisitor)i.apply(className, visitor);
                                        }
                                        cr.accept((ClassVisitor)visitor, 0);
                                        FutureEntry futureEntry = new FutureEntry(writer.toByteArray(), pathName);
                                        return futureEntry;
                                    }
                                    finally {
                                        Thread.currentThread().setContextClassLoader(old);
                                    }
                                }
                            }));
                        }
                    });
                }
                finally {
                    executorPool.shutdown();
                }
                if (transformed.isEmpty()) break block36;
                for (Future i : transformed) {
                    FutureEntry res = (FutureEntry)i.get();
                    Path classFile = this.transformedClassesDir.resolve(res.location);
                    Files.createDirectories(classFile.getParent(), new FileAttribute[0]);
                    OutputStream out = Files.newOutputStream(classFile, new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        IoUtils.copy((OutputStream)out, (InputStream)new ByteArrayInputStream(res.data));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
            }
            catch (Exception e) {
                throw new AppCreatorException("Failed to augment application classes", e);
            }
            finally {
                if (runnerClassLoader != null) {
                    try {
                        runnerClassLoader.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)"Failed to close runner classloader", (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public String getConfigPropertyName() {
        return "augment";
    }

    @Override
    public PropertiesHandler<AugmentPhase> getPropertiesHandler() {
        return new MappedPropertiesHandler<AugmentPhase>(){

            @Override
            public AugmentPhase getTarget() {
                return AugmentPhase.this;
            }
        }.map("output", (t, value) -> t.setOutputDir(Paths.get(value, new String[0]))).map("classes", (t, value) -> t.setAppClassesDir(Paths.get(value, new String[0]))).map("transformed-classes", (t, value) -> t.setTransformedClassesDir(Paths.get(value, new String[0]))).map("wiring-classes", (t, value) -> t.setWiringClassesDir(Paths.get(value, new String[0]))).map("config", (t, value) -> t.setConfigDir(Paths.get(value, new String[0])));
    }

    private static final class FutureEntry {
        final byte[] data;
        final String location;

        private FutureEntry(byte[] data, String location) {
            this.data = data;
            this.location = location;
        }
    }
}

