/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.creator.phase.curate;

import io.quarkus.bootstrap.BootstrapDependencyProcessingException;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.creator.AppCreationPhase;
import io.quarkus.creator.AppCreator;
import io.quarkus.creator.AppCreatorException;
import io.quarkus.creator.config.reader.MappedPropertiesHandler;
import io.quarkus.creator.config.reader.PropertiesConfigReaderException;
import io.quarkus.creator.config.reader.PropertiesHandler;
import io.quarkus.creator.outcome.OutcomeProviderRegistration;
import io.quarkus.creator.phase.curate.CurateOutcome;
import io.quarkus.creator.phase.curate.DefaultUpdateDiscovery;
import io.quarkus.creator.phase.curate.DependenciesOrigin;
import io.quarkus.creator.phase.curate.VersionUpdate;
import io.quarkus.creator.phase.curate.VersionUpdateNumber;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.jboss.logging.Logger;

public class CuratePhase
implements AppCreationPhase<CuratePhase> {
    public static final String CONFIG_PROP = "curate";
    public static final String CONFIG_PROP_DEPS_ORIGIN = "dependencies-origin";
    public static final String CONFIG_PROP_LOCAL_REPO = "local-repo";
    public static final String CONFIG_PROP_VERSION_UPDATE = "version-update";
    public static final String CONFIG_PROP_VERSION_UPDATE_NUMBER = "version-update-number";
    public static final String CONFIG_PROP_UPDATE_GROUP_ID = "update-groupId";
    private static final String GROUP_ID_SPLIT_EXPR = "\\s*(,|\\s)\\s*";
    private static final Logger log = Logger.getLogger(CuratePhase.class);
    private DependenciesOrigin depsOrigin = DependenciesOrigin.APPLICATION;
    private VersionUpdate update = VersionUpdate.NONE;
    private VersionUpdateNumber updateNumber = VersionUpdateNumber.MICRO;
    private Path localRepo;
    private Set<String> updateGroupIds = Collections.singleton("io.quarkus");

    public static String completePropertyName(String name) {
        return "curate." + name;
    }

    public void setInitialDeps(DependenciesOrigin initialDeps) {
        this.depsOrigin = initialDeps;
    }

    public void setUpdate(VersionUpdate update) {
        this.update = update;
    }

    public void setLocalRepo(Path localRepo) {
        this.localRepo = localRepo;
    }

    @Override
    public String getConfigPropertyName() {
        return CONFIG_PROP;
    }

    @Override
    public PropertiesHandler<CuratePhase> getPropertiesHandler() {
        return new MappedPropertiesHandler<CuratePhase>(){

            @Override
            public CuratePhase getTarget() throws PropertiesConfigReaderException {
                return CuratePhase.this;
            }
        }.map(CONFIG_PROP_DEPS_ORIGIN, (target, value) -> {
            this.depsOrigin = DependenciesOrigin.of(value);
            if (this.depsOrigin == DependenciesOrigin.UNKNOWN) {
                throw new PropertiesConfigReaderException("The value of initial-deps property is expected to be either " + (Object)((Object)DependenciesOrigin.APPLICATION) + " or " + (Object)((Object)DependenciesOrigin.LAST_UPDATE) + " but was " + value);
            }
        }).map(CONFIG_PROP_LOCAL_REPO, (target, value) -> {
            this.localRepo = Paths.get(value, new String[0]);
        }).map(CONFIG_PROP_VERSION_UPDATE, (target, value) -> {
            this.update = VersionUpdate.of(value);
            if (this.update == VersionUpdate.UNKNOWN) {
                throw new PropertiesConfigReaderException("The value of update property is expected to be one of " + (Object)((Object)VersionUpdate.LATEST) + ", " + (Object)((Object)VersionUpdate.NEXT) + " or " + (Object)((Object)VersionUpdate.NONE) + " but was " + value);
            }
        }).map(CONFIG_PROP_VERSION_UPDATE_NUMBER, (target, value) -> {
            this.updateNumber = VersionUpdateNumber.of(value);
            if (this.updateNumber == VersionUpdateNumber.UNKNOWN) {
                throw new PropertiesConfigReaderException("The value of update-number property is expected to be one of " + (Object)((Object)VersionUpdateNumber.MAJOR) + ", " + (Object)((Object)VersionUpdateNumber.MINOR) + " or " + (Object)((Object)VersionUpdateNumber.MICRO) + " but was " + value);
            }
        }).map(CONFIG_PROP_UPDATE_GROUP_ID, (target, value) -> {
            this.updateGroupIds = new HashSet<String>(Arrays.asList(value.split(GROUP_ID_SPLIT_EXPR)));
        });
    }

    @Override
    public void register(OutcomeProviderRegistration registration) throws AppCreatorException {
        registration.provides(CurateOutcome.class);
    }

    @Override
    public void provideOutcome(AppCreator ctx) throws AppCreatorException {
        List appDeps;
        AppModel initialDepsList;
        AppModelResolver modelResolver;
        AppArtifact appArtifact;
        CurateOutcome.Builder outcome;
        Path appJar;
        block27: {
            log.info((Object)("provideOutcome depsOrigin=" + (Object)((Object)this.depsOrigin) + ", versionUpdate=" + (Object)((Object)this.update) + ", versionUpdateNumber=" + (Object)((Object)this.updateNumber)));
            appJar = ctx.getAppJar();
            if (appJar == null) {
                throw new AppCreatorException("Application JAR has not been provided");
            }
            if (!Files.exists(appJar, new LinkOption[0])) {
                throw new AppCreatorException("Application " + appJar + " does not exist on disk");
            }
            outcome = CurateOutcome.builder();
            try {
                appArtifact = ModelUtils.resolveAppArtifact((Path)appJar);
            }
            catch (IOException e) {
                throw new AppCreatorException("Failed to resolve application artifact coordindates from " + appJar, e);
            }
            modelResolver = ctx.getArtifactResolver();
            try {
                if (modelResolver == null) {
                    BootstrapAppModelResolver bsResolver = new BootstrapAppModelResolver(MavenArtifactResolver.builder().setRepoHome(this.localRepo == null ? ctx.getWorkPath("repo") : this.localRepo).build());
                    bsResolver.relink(appArtifact, appJar);
                    List artifactRepos = bsResolver.resolveArtifactRepos(appArtifact);
                    if (!artifactRepos.isEmpty()) {
                        bsResolver.addRemoteRepositories(artifactRepos);
                        ArrayList<Repository> modelRepos = new ArrayList<Repository>(artifactRepos.size());
                        for (RemoteRepository repo : artifactRepos) {
                            Repository modelRepo = new Repository();
                            modelRepo.setId(repo.getId());
                            modelRepo.setUrl(repo.getUrl());
                            modelRepo.setLayout(repo.getContentType());
                            RepositoryPolicy policy = repo.getPolicy(true);
                            if (policy != null) {
                                modelRepo.setSnapshots(CuratePhase.toMavenRepoPolicy(policy));
                            }
                            if ((policy = repo.getPolicy(false)) != null) {
                                modelRepo.setReleases(CuratePhase.toMavenRepoPolicy(policy));
                            }
                            modelRepos.add(modelRepo);
                        }
                        outcome.setArtifactRepos(modelRepos);
                    }
                    modelResolver = bsResolver;
                } else {
                    modelResolver.relink(appArtifact, appJar);
                }
                outcome.setAppModelResolver(modelResolver);
                if (this.depsOrigin == DependenciesOrigin.LAST_UPDATE) {
                    log.info((Object)"Looking for the state of the last update");
                    Path statePath = null;
                    try {
                        AppArtifact stateArtifact = ModelUtils.getStateArtifact((AppArtifact)appArtifact);
                        String latest = modelResolver.getLatestVersion(stateArtifact, null, false);
                        if (!stateArtifact.getVersion().equals(latest)) {
                            stateArtifact = new AppArtifact(stateArtifact.getGroupId(), stateArtifact.getArtifactId(), stateArtifact.getClassifier(), stateArtifact.getType(), latest);
                        }
                        statePath = modelResolver.resolve(stateArtifact);
                        outcome.setStateArtifact(stateArtifact);
                        log.info((Object)("- located the state at " + statePath));
                    }
                    catch (AppModelResolverException stateArtifact) {
                        // empty catch block
                    }
                    if (statePath != null) {
                        Model model;
                        try {
                            model = ModelUtils.readModel(statePath);
                        }
                        catch (IOException e) {
                            throw new AppCreatorException("Failed to read application state " + statePath, e);
                        }
                        List modelStateDeps = model.getDependencies();
                        ArrayList<AppDependency> updatedDeps = new ArrayList<AppDependency>(modelStateDeps.size());
                        String groupIdProp = "${creator.app.groupId}";
                        for (Dependency modelDep : modelStateDeps) {
                            if (modelDep.getGroupId().equals("${creator.app.groupId}")) continue;
                            updatedDeps.add(new AppDependency(new AppArtifact(modelDep.getGroupId(), modelDep.getArtifactId(), modelDep.getClassifier(), modelDep.getType(), modelDep.getVersion()), modelDep.getScope(), modelDep.isOptional()));
                        }
                        initialDepsList = modelResolver.resolveModel(appArtifact, updatedDeps);
                        outcome.setLoadedFromState();
                        break block27;
                    }
                    initialDepsList = modelResolver.resolveModel(appArtifact);
                    break block27;
                }
                initialDepsList = modelResolver.resolveModel(appArtifact);
            }
            catch (AppModelResolverException e) {
                throw new AppCreatorException("Failed to resolve initial application dependencies", e);
            }
        }
        outcome.setAppModel(initialDepsList);
        if (this.update == VersionUpdate.NONE) {
            ctx.pushOutcome(outcome.build());
            return;
        }
        log.info((Object)"Checking for available updates");
        try {
            appDeps = ModelUtils.getUpdateCandidates((List)ModelUtils.readAppModel((Path)appJar, (AppArtifact)appArtifact).getDependencies(), (List)initialDepsList.getAllDependencies(), this.updateGroupIds);
        }
        catch (BootstrapDependencyProcessingException | IOException e) {
            throw new AppCreatorException("Failed to determine the list of dependencies to update", e);
        }
        DefaultUpdateDiscovery ud = new DefaultUpdateDiscovery(modelResolver, this.updateNumber);
        ArrayList<AppDependency> availableUpdates = null;
        int i = 0;
        while (i < appDeps.size()) {
            String updatedVersion;
            AppDependency dep = (AppDependency)appDeps.get(i++);
            AppArtifact depArtifact = dep.getArtifact();
            String string = updatedVersion = this.update == VersionUpdate.NEXT ? ud.getNextVersion(depArtifact) : ud.getLatestVersion(depArtifact);
            if (depArtifact.getVersion().equals(updatedVersion)) continue;
            log.info((Object)(dep.getArtifact() + " -> " + updatedVersion));
            if (availableUpdates == null) {
                availableUpdates = new ArrayList<AppDependency>();
            }
            availableUpdates.add(new AppDependency(new AppArtifact(depArtifact.getGroupId(), depArtifact.getArtifactId(), depArtifact.getClassifier(), depArtifact.getType(), updatedVersion), dep.getScope()));
        }
        if (availableUpdates != null) {
            outcome.setUpdatedDeps(availableUpdates);
            ctx.pushOutcome(outcome.build());
        } else {
            log.info((Object)"- no updates available");
            ctx.pushOutcome(outcome.build());
        }
    }

    private static org.apache.maven.model.RepositoryPolicy toMavenRepoPolicy(RepositoryPolicy policy) {
        org.apache.maven.model.RepositoryPolicy mvnPolicy = new org.apache.maven.model.RepositoryPolicy();
        mvnPolicy.setEnabled(policy.isEnabled());
        mvnPolicy.setChecksumPolicy(policy.getChecksumPolicy());
        mvnPolicy.setUpdatePolicy(policy.getUpdatePolicy());
        return mvnPolicy;
    }

    private static void logDeps(String header, List<AppDependency> deps) {
        ArrayList<String> list = new ArrayList<String>(deps.size());
        for (AppDependency dep : deps) {
            list.add(dep.toString());
        }
        Collections.sort(list);
        System.out.println(header);
        for (String str : list) {
            System.out.println("- " + str);
        }
    }
}

