/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.creator.phase.curate;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.creator.AppCreatorException;
import io.quarkus.creator.phase.curate.UpdateDiscovery;
import io.quarkus.creator.phase.curate.VersionUpdateNumber;
import java.util.List;

public class DefaultUpdateDiscovery
implements UpdateDiscovery {
    private final AppModelResolver resolver;
    private final VersionUpdateNumber updateNumber;

    public DefaultUpdateDiscovery(AppModelResolver resolver, VersionUpdateNumber updateNumber) {
        this.resolver = resolver;
        this.updateNumber = updateNumber;
    }

    @Override
    public List<String> listUpdates(AppArtifact artifact) throws AppCreatorException {
        try {
            return this.resolver.listLaterVersions(artifact, this.resolveUpToVersion(artifact), false);
        }
        catch (AppModelResolverException e) {
            throw new AppCreatorException("Failed to collect later versions", e);
        }
    }

    @Override
    public String getNextVersion(AppArtifact artifact) throws AppCreatorException {
        try {
            return this.resolver.getNextVersion(artifact, this.resolveUpToVersion(artifact), false);
        }
        catch (AppModelResolverException e) {
            throw new AppCreatorException("Failed to determine the next available version", e);
        }
    }

    @Override
    public String getLatestVersion(AppArtifact artifact) throws AppCreatorException {
        try {
            return this.resolver.getLatestVersion(artifact, this.resolveUpToVersion(artifact), false);
        }
        catch (AppModelResolverException e) {
            throw new AppCreatorException("Failed to determine the latest available version", e);
        }
    }

    private String resolveUpToVersion(AppArtifact artifact) throws AppCreatorException {
        long minor;
        if (this.updateNumber == VersionUpdateNumber.MAJOR) {
            return null;
        }
        String version = artifact.getVersion();
        int majorMinorSep = version.indexOf(46);
        if (majorMinorSep <= 0) {
            throw new AppCreatorException("Failed to determine the major version in " + version);
        }
        String majorStr = version.substring(0, majorMinorSep);
        if (this.updateNumber == VersionUpdateNumber.MINOR) {
            long major;
            try {
                major = Long.parseLong(majorStr);
            }
            catch (NumberFormatException e) {
                throw new AppCreatorException("The version is expected to start with a number indicating the major version: " + version);
            }
            return String.valueOf(major + 1L) + ".alpha";
        }
        int minorMicroSep = version.indexOf(46, majorMinorSep + 1);
        if (minorMicroSep <= 0) {
            throw new AppCreatorException("Failed to determine the minor version in " + version);
        }
        String minorStr = version.substring(majorMinorSep + 1, minorMicroSep);
        try {
            minor = Long.parseLong(minorStr);
        }
        catch (NumberFormatException e) {
            throw new AppCreatorException("Failed to parse the minor number in version: " + version);
        }
        return majorStr + "." + String.valueOf(minor + 1L) + ".alpha";
    }
}

