/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.creator.phase.nativeimage;

import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ReportAnalyzer {
    final List<Node> parents = new ArrayList<Node>();
    final Map<String, List<Node>> byClassMap = new HashMap<String, List<Node>>();
    final Map<String, List<Node>> constructors = new HashMap<String, List<Node>>();
    static Pattern PATTERN = Pattern.compile("(.*?)([^\\s(]+)\\.([^.]+\\(.*?\\):[^\\s])");

    public ReportAnalyzer(String report) {
        try {
            ArrayDeque<String> lines = new ArrayDeque<String>();
            try (BufferedReader in = Files.newBufferedReader(Paths.get(report, new String[0]));){
                String re = in.readLine();
                while (re != null) {
                    lines.add(re);
                    re = in.readLine();
                }
            }
            String first = (String)lines.pop();
            if (!first.equals("VM Entry Points")) {
                throw new IllegalArgumentException("Unexpected first line in file " + first);
            }
            Node last = null;
            for (String line : lines) {
                Node parent;
                char c;
                int start;
                if (line.trim().isEmpty()) continue;
                int lc = 0;
                for (start = 0; start < line.length() && (c = line.charAt(start)) != '\u251c' && c != '\u2514'; ++start) {
                    ++lc;
                }
                if (line.length() < start + 3) continue;
                Matcher matcher = PATTERN.matcher(line.substring(start + 3));
                if (!matcher.find()) {
                    throw new RuntimeException("Failed " + line);
                }
                String type = matcher.group(1).trim();
                String clz = matcher.group(2);
                String method = matcher.group(3);
                if (last == null) {
                    parent = null;
                } else if (last.indent < lc) {
                    parent = last;
                } else {
                    parent = last;
                    while (parent != null && (parent = parent.parent) != null && parent.indent >= lc) {
                    }
                }
                Node n = new Node(lc, type, clz, method, parent);
                if (parent == null) {
                    this.parents.add(n);
                } else {
                    n.parent.children.add(n);
                }
                this.byClassMap.computeIfAbsent(clz, k -> new ArrayList()).add(n);
                if (method.startsWith("<init>")) {
                    this.constructors.computeIfAbsent(clz, k -> new ArrayList()).add(n);
                }
                last = n;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String analyse(String className, String methodName) throws Exception {
        List dm = ((List)this.byClassMap.getOrDefault(className, new ArrayList())).stream().filter(s -> s.method.startsWith(methodName + "(")).collect(Collectors.toList());
        ArrayDeque runQueue = new ArrayDeque(dm);
        HashSet<String> attemptedClasses = new HashSet<String>();
        if (methodName.equals("<init>")) {
            attemptedClasses.add(className);
        }
        StringBuilder ret = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        block0: while (!runQueue.isEmpty()) {
            Node current = (Node)runQueue.pop();
            sb.append("Possible path to " + current.className + "." + current.method + "\n");
            while (current != null) {
                sb.append("\t" + current.className + "." + current.method + '\n');
                String reason = null;
                if (current.parent == null || current.parent.children.size() > 1) {
                    if (current.type.equals("is overridden by")) {
                        reason = "This is an implementation of " + current.parent.className + " printing path to constructors of " + current.className + "\n";
                    } else if (current.type.equals("is implemented by")) {
                        reason = "This is an implementation of " + current.parent.className + " printing path to constructors of " + current.className + "\n";
                    }
                }
                if (reason != null) {
                    if (!attemptedClasses.contains(current.className)) {
                        attemptedClasses.add(current.className);
                        List toAdd = this.constructors.getOrDefault(current.className, new ArrayList());
                        runQueue.addAll(toAdd);
                        sb.append(reason + '\n');
                        sb.append("\n");
                        ret.append((CharSequence)sb);
                    }
                    sb.setLength(0);
                    continue block0;
                }
                current = current.parent;
            }
        }
        ret.append((CharSequence)sb);
        return ret.toString();
    }

    public static class Node {
        final int indent;
        final String type;
        final String className;
        final String method;
        final Node parent;
        List<Node> children = new ArrayList<Node>();

        Node(int indent, String type, String className, String method, Node parent) {
            this.indent = indent;
            this.type = type;
            this.className = className;
            this.method = method;
            this.parent = parent;
        }

        public String toString() {
            return this.className + '.' + this.method;
        }
    }
}

