/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.creator.phase.runnerjar;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.bootstrap.util.ZipUtils;
import io.quarkus.creator.AppCreationPhase;
import io.quarkus.creator.AppCreator;
import io.quarkus.creator.AppCreatorException;
import io.quarkus.creator.config.reader.MappedPropertiesHandler;
import io.quarkus.creator.config.reader.PropertiesHandler;
import io.quarkus.creator.outcome.OutcomeProviderRegistration;
import io.quarkus.creator.phase.augment.AugmentOutcome;
import io.quarkus.creator.phase.curate.CurateOutcome;
import io.quarkus.creator.phase.runnerjar.RunnerJarOutcome;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.logging.Logger;

public class RunnerJarPhase
implements AppCreationPhase<RunnerJarPhase>,
RunnerJarOutcome {
    private static final String DEFAULT_MAIN_CLASS = "io.quarkus.runner.GeneratedMain";
    private static final Logger log = Logger.getLogger(RunnerJarPhase.class);
    private static final Set<String> IGNORED_ENTRIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("META-INF/INDEX.LIST", "META-INF/MANIFEST.MF", "module-info.class", "META-INF/LICENSE", "META-INF/LICENSE.txt", "META-INF/LICENSE.md", "META-INF/NOTICE", "META-INF/NOTICE.txt", "META-INF/NOTICE.md", "META-INF/README", "META-INF/README.txt", "META-INF/README.md", "META-INF/DEPENDENCIES", "META-INF/beans.xml", "META-INF/quarkus-config-roots.list", "META-INF/quarkus-javadoc.properties", "META-INF/quarkus-extension.properties", "META-INF/quarkus-deployment-dependency.graph", "LICENSE")));
    private Path outputDir;
    private Path libDir;
    private Path runnerJar;
    private String finalName;
    private String mainClass = "io.quarkus.runner.GeneratedMain";
    private boolean uberJar;

    public RunnerJarPhase setOutputDir(Path outputDir) {
        this.outputDir = outputDir;
        return this;
    }

    public RunnerJarPhase setLibDir(Path libDir) {
        this.libDir = libDir;
        return this;
    }

    public RunnerJarPhase setFinalName(String finalName) {
        this.finalName = finalName;
        return this;
    }

    public RunnerJarPhase setMainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public RunnerJarPhase setUberJar(boolean uberJar) {
        this.uberJar = uberJar;
        return this;
    }

    @Override
    public Path getRunnerJar() {
        return this.runnerJar;
    }

    @Override
    public Path getLibDir() {
        return this.libDir;
    }

    @Override
    public void register(OutcomeProviderRegistration registration) throws AppCreatorException {
        registration.provides(RunnerJarOutcome.class);
    }

    @Override
    public void provideOutcome(AppCreator ctx) throws AppCreatorException {
        String name;
        int i;
        CurateOutcome appState = ctx.resolveOutcome(CurateOutcome.class);
        this.outputDir = this.outputDir == null ? ctx.getWorkPath(new String[0]) : IoUtils.mkdirs((Path)this.outputDir);
        this.libDir = IoUtils.mkdirs((Path)(this.libDir == null ? this.outputDir.resolve("lib") : this.libDir));
        if (this.finalName == null && (i = (name = RunnerJarPhase.toUri(appState.getAppArtifact().getPath().getFileName())).lastIndexOf(46)) > 0) {
            this.finalName = name.substring(0, i);
        }
        this.runnerJar = this.outputDir.resolve(this.finalName + "-runner.jar");
        IoUtils.recursiveDelete((Path)this.runnerJar);
        try (FileSystem zipFs = ZipUtils.newZip((Path)this.runnerJar);){
            this.buildRunner(zipFs, appState, ctx.resolveOutcome(AugmentOutcome.class));
        }
        catch (Exception e) {
            throw new AppCreatorException("Failed to build a runner jar", e);
        }
        try {
            this.runnerJar.toFile().setReadable(true, false);
        }
        catch (Exception e) {
            log.warn((Object)("Unable to set proper permissions on " + this.runnerJar));
        }
        if (this.uberJar) {
            try {
                Path originalFile = this.outputDir.resolve(this.finalName + ".jar.original");
                Files.deleteIfExists(originalFile);
                Files.move(this.outputDir.resolve(this.finalName + ".jar"), originalFile, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new AppCreatorException("Unable to build uberjar", e);
            }
        }
        ctx.pushOutcome(RunnerJarOutcome.class, this);
    }

    private void buildRunner(final FileSystem runnerZipFs, CurateOutcome curateOutcome, AugmentOutcome augmentOutcome) throws Exception {
        Throwable throwable;
        log.info((Object)("Building jar: " + this.runnerJar));
        AppModelResolver depResolver = curateOutcome.getArtifactResolver();
        final HashMap seen = new HashMap();
        final HashMap duplicateCatcher = new HashMap();
        StringBuilder classPath = new StringBuilder();
        final HashMap<String, List<byte[]>> services = new HashMap<String, List<byte[]>>();
        List appDeps = curateOutcome.getEffectiveModel().getUserDependencies();
        for (Object appDep : appDeps) {
            AppArtifact appArtifact = appDep.getArtifact();
            Path resolvedDep = depResolver.resolve(appArtifact);
            if (this.uberJar) {
                FileSystem artifactFs = ZipUtils.newFileSystem((Path)resolvedDep);
                throwable = null;
                try {
                    for (final Path root : artifactFs.getRootDirectories()) {
                        Files.walkFileTree(root, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>((AppDependency)appDep, seen){
                            final /* synthetic */ AppDependency val$appDep;
                            final /* synthetic */ Map val$seen;
                            {
                                this.val$appDep = appDependency;
                                this.val$seen = map3;
                            }

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                String relativePath = RunnerJarPhase.toUri(root.relativize(dir));
                                if (!relativePath.isEmpty()) {
                                    RunnerJarPhase.this.addDir(runnerZipFs, relativePath);
                                }
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                String relativePath = RunnerJarPhase.toUri(root.relativize(file));
                                if (relativePath.startsWith("META-INF/services/") && relativePath.length() > 18) {
                                    services.computeIfAbsent(relativePath, u -> new ArrayList()).add(RunnerJarPhase.read(file));
                                    return FileVisitResult.CONTINUE;
                                }
                                if (!IGNORED_ENTRIES.contains(relativePath)) {
                                    duplicateCatcher.computeIfAbsent(relativePath, a -> new HashSet()).add(this.val$appDep);
                                    if (!this.val$seen.containsKey(relativePath)) {
                                        this.val$seen.put(relativePath, this.val$appDep.toString());
                                        Files.copy(file, runnerZipFs.getPath(relativePath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                                    } else if (!relativePath.endsWith(".class")) {
                                        log.warn((Object)("Duplicate entry " + relativePath + " entry from " + this.val$appDep + " will be ignored. Existing file was provided by " + (String)this.val$seen.get(relativePath)));
                                    }
                                }
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (artifactFs == null) continue;
                    if (throwable != null) {
                        try {
                            artifactFs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    artifactFs.close();
                    continue;
                }
            }
            String fileName = appArtifact.getGroupId() + "." + resolvedDep.getFileName();
            Path targetPath = this.libDir.resolve(fileName);
            Files.copy(resolvedDep, targetPath, StandardCopyOption.REPLACE_EXISTING);
            classPath.append(" lib/" + fileName);
        }
        HashSet explained = new HashSet();
        for (Map.Entry entry : duplicateCatcher.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1 || !explained.add(entry.getValue())) continue;
            log.warn((Object)("Dependencies with duplicate files detected. The dependencies " + entry.getValue() + " contain duplicate files, e.g. " + (String)entry.getKey()));
        }
        final Path wiringClassesDir = augmentOutcome.getWiringClassesDir();
        Files.walk(wiringClassesDir, new FileVisitOption[0]).forEach(new Consumer<Path>(){

            @Override
            public void accept(Path path) {
                try {
                    String relativePath = RunnerJarPhase.toUri(wiringClassesDir.relativize(path));
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        if (!seen.containsKey(relativePath + "/") && !relativePath.isEmpty()) {
                            seen.put(relativePath + "/", "Current Application");
                            RunnerJarPhase.this.addDir(runnerZipFs, relativePath);
                        }
                        return;
                    }
                    if (relativePath.startsWith("META-INF/services/") && relativePath.length() > 18) {
                        if (Files.size(path) > Integer.MAX_VALUE) {
                            throw new RuntimeException("Can't process class files larger than Integer.MAX_VALUE bytes");
                        }
                        services.computeIfAbsent(relativePath, u -> new ArrayList()).add(Files.readAllBytes(path));
                        return;
                    }
                    seen.put(relativePath, "Current Application");
                    Files.copy(path, runnerZipFs.getPath(relativePath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.copyFiles(augmentOutcome.getAppClassesDir(), runnerZipFs, services);
        if (Files.exists(augmentOutcome.getConfigDir(), new LinkOption[0])) {
            this.copyFiles(augmentOutcome.getConfigDir(), runnerZipFs, services);
        }
        this.copyFiles(augmentOutcome.getTransformedClassesDir(), runnerZipFs, services);
        this.generateManifest(runnerZipFs, classPath.toString());
        for (Map.Entry entry : services.entrySet()) {
            OutputStream os = Files.newOutputStream(runnerZipFs.getPath((String)entry.getKey(), new String[0]), new OpenOption[0]);
            throwable = null;
            try {
                for (byte[] i : (List)entry.getValue()) {
                    os.write(i);
                    os.write(10);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (os == null) continue;
                if (throwable != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    continue;
                }
                os.close();
            }
        }
    }

    private void generateManifest(FileSystem runnerZipFs, String classPath) throws IOException {
        String existingMainClass;
        Path manifestPath = runnerZipFs.getPath("META-INF", "MANIFEST.MF");
        Manifest manifest = new Manifest();
        if (Files.exists(manifestPath, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(manifestPath, new OpenOption[0]);){
                manifest.read(is);
            }
        }
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        if (attributes.containsKey(Attributes.Name.CLASS_PATH)) {
            log.warn((Object)"Your MANIFEST.MF already defined a CLASS_PATH entry. Quarkus has overwritten this existing entry.");
        }
        attributes.put(Attributes.Name.CLASS_PATH, classPath);
        if (attributes.containsKey(Attributes.Name.MAIN_CLASS) && !this.mainClass.equals(existingMainClass = attributes.getValue(Attributes.Name.MAIN_CLASS))) {
            log.warn((Object)"Your MANIFEST.MF already defined a MAIN_CLASS entry. Quarkus has overwritten your existing entry.");
        }
        attributes.put(Attributes.Name.MAIN_CLASS, this.mainClass);
        try (OutputStream os = Files.newOutputStream(manifestPath, new OpenOption[0]);){
            manifest.write(os);
        }
    }

    private void copyFiles(final Path dir, final FileSystem fs, final Map<String, List<byte[]>> services) throws IOException {
        try {
            Files.walk(dir, new FileVisitOption[0]).forEach(new Consumer<Path>(){

                @Override
                public void accept(Path path) {
                    block7: {
                        Path file = dir.relativize(path);
                        String relativePath = RunnerJarPhase.toUri(file);
                        if (relativePath.isEmpty()) {
                            return;
                        }
                        try {
                            if (Files.isDirectory(path, new LinkOption[0])) {
                                RunnerJarPhase.this.addDir(fs, relativePath);
                                break block7;
                            }
                            if (relativePath.startsWith("META-INF/services/") && relativePath.length() > 18) {
                                byte[] content;
                                try {
                                    content = Files.readAllBytes(path);
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                                services.computeIfAbsent(relativePath, u -> new ArrayList()).add(content);
                                break block7;
                            }
                            Files.copy(path, fs.getPath(relativePath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException re) {
            Throwable cause = re.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw re;
        }
    }

    private void addDir(FileSystem fs, String relativePath) throws IOException, FileAlreadyExistsException {
        block2: {
            Path targetDir = fs.getPath(relativePath, new String[0]);
            try {
                Files.createDirectory(targetDir, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                throw e;
            }
        }
    }

    private static byte[] read(Path p) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try (InputStream in = Files.newInputStream(p, new OpenOption[0]);){
            int r;
            while ((r = in.read(buffer)) > 0) {
                out.write(buffer, 0, r);
            }
        }
        return out.toByteArray();
    }

    @Override
    public String getConfigPropertyName() {
        return "runner-jar";
    }

    @Override
    public PropertiesHandler<RunnerJarPhase> getPropertiesHandler() {
        return new MappedPropertiesHandler<RunnerJarPhase>(){

            @Override
            public RunnerJarPhase getTarget() {
                return RunnerJarPhase.this;
            }
        }.map("output", (t, value) -> t.setOutputDir(Paths.get(value, new String[0]))).map("lib", (t, value) -> t.setLibDir(Paths.get(value, new String[0]))).map("final-name", RunnerJarPhase::setFinalName).map("main-class", RunnerJarPhase::setMainClass).map("uber-jar", (t, value) -> t.setUberJar(Boolean.parseBoolean(value)));
    }

    private static String toUri(Path path) {
        if (path.isAbsolute()) {
            return path.toUri().getPath();
        }
        if (path.getNameCount() == 0) {
            return "";
        }
        return RunnerJarPhase.toUri(new StringBuilder(), path, 0).toString();
    }

    private static StringBuilder toUri(StringBuilder b, Path path, int seg) {
        b.append(path.getName(seg));
        if (seg < path.getNameCount() - 1) {
            b.append('/');
            RunnerJarPhase.toUri(b, path, seg + 1);
        }
        return b;
    }
}

