/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.creator.config.reader;

import io.quarkus.creator.config.reader.PropertiesConfigReaderException;
import io.quarkus.creator.config.reader.PropertiesConfigUtils;
import io.quarkus.creator.config.reader.PropertiesHandler;
import io.quarkus.creator.config.reader.PropertyContext;
import io.quarkus.creator.config.reader.PropertyLine;
import io.quarkus.creator.config.reader.PropertyLineConverter;
import io.quarkus.creator.config.reader.UnrecognizedNameElementHandler;
import io.quarkus.creator.config.reader.UnrecognizedPropertyHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class PropertiesConfigReader<T> {
    private final UnrecognizedPropertyHandler unrecognizedPropHandler;
    private final UnrecognizedNameElementHandler unrecognizedChildHandler;
    private final T result;
    private PropertyContext root;
    private PropertyContext current;

    public static <T> PropertiesConfigReader<T> getInstance(PropertiesHandler<T> handler) throws PropertiesConfigReaderException {
        return PropertiesConfigReader.getInstance(handler, (PropertyLine line) -> PropertiesConfigUtils.unrecognizedProperty(line));
    }

    public static <T> PropertiesConfigReader<T> getInstance(PropertiesHandler<T> handler, UnrecognizedPropertyHandler unrecognizedPropHandler) throws PropertiesConfigReaderException {
        return PropertiesConfigReader.getInstance(handler, unrecognizedPropHandler, (line, nameElement) -> {});
    }

    public static <T> PropertiesConfigReader<T> getInstance(PropertiesHandler<T> handler, UnrecognizedNameElementHandler unrecognizedChildHandler) throws PropertiesConfigReaderException {
        return PropertiesConfigReader.getInstance(handler, line -> PropertiesConfigUtils.unrecognizedProperty(line), unrecognizedChildHandler);
    }

    public static <T> PropertiesConfigReader<T> getInstance(PropertiesHandler<T> handler, UnrecognizedPropertyHandler unrecognizedPropHandler, UnrecognizedNameElementHandler unrecognizedChildHandler) throws PropertiesConfigReaderException {
        return new PropertiesConfigReader<T>(handler, unrecognizedPropHandler, unrecognizedChildHandler);
    }

    protected PropertiesConfigReader(PropertiesHandler<T> handler, UnrecognizedPropertyHandler unrecognizedPropHandler, UnrecognizedNameElementHandler unrecognizedChildHandler) throws PropertiesConfigReaderException {
        this.unrecognizedPropHandler = unrecognizedPropHandler;
        this.unrecognizedChildHandler = unrecognizedChildHandler;
        this.result = handler.getTarget();
        this.root = new PropertyContext(null, null, 0, new String[0], handler);
        this.root.o = this.result;
        this.current = this.root;
    }

    public T read(Path p) throws PropertiesConfigReaderException {
        this.build(this.readLines(p));
        return this.result;
    }

    public T read(Properties props) throws PropertiesConfigReaderException {
        ArrayList<PropertyLine> lines = new ArrayList<PropertyLine>(props.size());
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String name = entry.getKey().toString();
            lines.add(new PropertyLine(name, entry.getValue().toString()));
        }
        this.build(lines);
        return this.result;
    }

    public T read(Map<String, String> props) throws PropertiesConfigReaderException {
        ArrayList<PropertyLine> lines = new ArrayList<PropertyLine>(props.size());
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String name = entry.getKey();
            lines.add(new PropertyLine(name, entry.getValue()));
        }
        this.build(lines);
        return this.result;
    }

    public <S> T read(Iterable<S> config, PropertyLineConverter<S> converter) throws PropertiesConfigReaderException {
        ArrayList<PropertyLine> lines = new ArrayList<PropertyLine>();
        for (S src : config) {
            lines.add(converter.toPropertyLine(src));
        }
        this.build(lines);
        return this.result;
    }

    private void build(List<PropertyLine> lines) throws PropertiesConfigReaderException {
        Collections.sort(lines);
        for (PropertyLine line : lines) {
            this.handleProperty(line);
        }
        while (this.current.parent != null) {
            this.current.parent.handler.setNestedOnObject(this.current.parent.o, this.current.mappedName, this.current.o);
            this.current = this.current.parent;
        }
    }

    private List<PropertyLine> readLines(Path p) throws PropertiesConfigReaderException {
        ArrayList<PropertyLine> lines = new ArrayList<PropertyLine>();
        try (BufferedReader reader = Files.newBufferedReader(p);){
            StringBuilder nameElBuf = new StringBuilder();
            ArrayList<String> nameEls = new ArrayList<String>(1);
            String line = reader.readLine();
            int lineI = 0;
            while (line != null) {
                int i;
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') {
                    line = reader.readLine();
                    continue;
                }
                nameEls.clear();
                int equalsI = -1;
                for (i = 0; i < line.length(); ++i) {
                    char c = line.charAt(i);
                    if (c == '=') {
                        nameEls.add(nameElBuf.toString());
                        nameElBuf.setLength(0);
                        equalsI = i;
                        break;
                    }
                    if (c == '.') {
                        nameEls.add(nameElBuf.toString());
                        nameElBuf.setLength(0);
                        continue;
                    }
                    nameElBuf.append(c);
                }
                if (equalsI <= 0) {
                    throw new PropertiesConfigReaderException("Line '" + line + "' does not follow format <key>=<value>");
                }
                lines.add(new PropertyLine(line, lineI++, line.substring(0, equalsI), nameEls.toArray(new String[nameEls.size()]), line.substring(i + 1)));
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new PropertiesConfigReaderException("Failed read " + p, e);
        }
        return lines;
    }

    protected void handleProperty(PropertyLine line) throws PropertiesConfigReaderException {
        int j;
        int i;
        int minLength = Math.min(this.current.nameEls.length, line.nameElements.length);
        for (i = 0; i < minLength && this.current.nameEls[i].equals(line.nameElements[i]); ++i) {
        }
        for (j = this.current.nameEls.length; j > i; j -= this.current.mappedNameElements) {
            this.current.parent.handler.setNestedOnObject(this.current.parent.o, this.current.mappedName, this.current.o);
            this.current = this.current.parent;
        }
        j = i;
        while (j < line.nameElements.length - 1) {
            String namePart;
            PropertiesHandler<?> childHandler;
            if ((childHandler = this.current.handler.getNestedHandler(namePart = line.getNamePart(i, j++))) == null) {
                this.unrecognizedChildHandler.unrecognizedNameElement(line, j);
                continue;
            }
            this.current = new PropertyContext(this.current, namePart, j - i, Arrays.copyOf(line.nameElements, j), childHandler);
            this.current.o = childHandler.getTarget();
            i = j;
        }
        this.current.nestedProperty = line;
        this.current.nameElement = i;
        if (!this.current.handler.setOnObject(this.current)) {
            this.unrecognizedPropHandler.unrecognizedProperty(line);
        }
        this.current.nestedProperty = null;
        this.current.nameElement = -1;
    }
}

