/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.creator.outcome;

import io.quarkus.creator.AppCreatorException;
import io.quarkus.creator.outcome.Errors;
import io.quarkus.creator.outcome.OutcomeProviderDescription;
import io.quarkus.creator.outcome.OutcomeResolverFactory;
import java.util.Collections;
import java.util.Map;

public class OutcomeResolver<C> {
    private final Map<Class<?>, OutcomeProviderDescription<C>> outcomeProviders;

    protected OutcomeResolver(OutcomeResolverFactory<C> factory) {
        this.outcomeProviders = Collections.unmodifiableMap(factory.providers);
    }

    public void resolve(C ctx, Class<?> outcomeType) throws AppCreatorException {
        OutcomeProviderDescription<C> phaseDescr = this.outcomeProviders.get(outcomeType);
        if (phaseDescr == null) {
            throw new AppCreatorException(Errors.noProviderForOutcome(outcomeType));
        }
        if (phaseDescr.isFlagOn(2)) {
            throw new AppCreatorException(Errors.promisedOutcomeNotProvided(phaseDescr.provider, outcomeType));
        }
        if (!phaseDescr.setFlag(1)) {
            throw new AppCreatorException(Errors.circularPhaseDependency(outcomeType, phaseDescr.provider));
        }
        phaseDescr.provider.provideOutcome(ctx);
        phaseDescr.clearFlag(1);
        if (!phaseDescr.setFlag(2)) {
            throw new AppCreatorException("Race condition: failed to mark provider " + phaseDescr.provider.getClass().getName() + " as processed");
        }
    }
}

