/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.creator.phase.augment;

import io.quarkus.bootstrap.BootstrapDependencyProcessingException;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.bootstrap.util.ZipUtils;
import io.quarkus.builder.BuildResult;
import io.quarkus.creator.AppCreationPhase;
import io.quarkus.creator.AppCreator;
import io.quarkus.creator.AppCreatorException;
import io.quarkus.creator.config.reader.MappedPropertiesHandler;
import io.quarkus.creator.config.reader.PropertiesHandler;
import io.quarkus.creator.outcome.OutcomeProviderRegistration;
import io.quarkus.creator.phase.augment.AugmentOutcome;
import io.quarkus.creator.phase.curate.CurateOutcome;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.ClassOutput;
import io.quarkus.deployment.QuarkusAugmentor;
import io.quarkus.deployment.QuarkusClassWriter;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateOutputBuildItem;
import io.quarkus.gizmo.NullWriter;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class AugmentPhase
implements AppCreationPhase<AugmentPhase>,
AugmentOutcome {
    private static final Logger log = Logger.getLogger(AugmentPhase.class);
    private static final String META_INF = "META-INF";
    private Path outputDir;
    private Path appClassesDir;
    private Path transformedClassesDir;
    private Path wiringClassesDir;
    private Path generatedSourcesDir;
    private Path configDir;
    private Map<Path, Set<String>> transformedClassesByJar;
    private Properties buildSystemProperties;

    public AugmentPhase setOutputDir(Path outputDir) {
        this.outputDir = outputDir;
        return this;
    }

    public AugmentPhase setAppClassesDir(Path appClassesDir) {
        this.appClassesDir = appClassesDir;
        return this;
    }

    public AugmentPhase setTransformedClassesDir(Path transformedClassesDir) {
        this.transformedClassesDir = transformedClassesDir;
        return this;
    }

    public AugmentPhase setWiringClassesDir(Path wiringClassesDir) {
        this.wiringClassesDir = wiringClassesDir;
        return this;
    }

    public AugmentPhase setConfigDir(Path configDir) {
        this.configDir = configDir;
        return this;
    }

    public AugmentPhase setGeneratedSourcesDir(Path generatedSourcesDir) {
        this.generatedSourcesDir = generatedSourcesDir;
        return this;
    }

    public AugmentPhase setBuildSystemProperties(Properties buildSystemProperties) {
        this.buildSystemProperties = buildSystemProperties;
        return this;
    }

    @Override
    public Path getAppClassesDir() {
        return this.appClassesDir;
    }

    @Override
    public Path getTransformedClassesDir() {
        return this.transformedClassesDir;
    }

    @Override
    public Path getWiringClassesDir() {
        return this.wiringClassesDir;
    }

    @Override
    public Path getConfigDir() {
        return this.configDir;
    }

    @Override
    public Map<Path, Set<String>> getTransformedClassesByJar() {
        return this.transformedClassesByJar;
    }

    @Override
    public void register(OutcomeProviderRegistration registration) throws AppCreatorException {
        registration.provides(AugmentOutcome.class);
    }

    @Override
    public void provideOutcome(AppCreator ctx) throws AppCreatorException {
        CurateOutcome appState = ctx.resolveOutcome(CurateOutcome.class);
        Path path = this.outputDir = this.outputDir == null ? ctx.getWorkPath(new String[0]) : IoUtils.mkdirs((Path)this.outputDir);
        if (this.appClassesDir == null) {
            this.appClassesDir = this.outputDir.resolve("classes");
        }
        if (!Files.exists(this.appClassesDir, new LinkOption[0])) {
            Path appJar = appState.getAppArtifact().getPath();
            if (appJar == null) {
                try {
                    Files.createDirectory(this.appClassesDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new AppCreatorException("Failed to create classes directory " + this.appClassesDir, e);
                }
            }
            try {
                ZipUtils.unzip((Path)appJar, (Path)this.appClassesDir);
            }
            catch (IOException e) {
                throw new AppCreatorException("Failed to unzip " + appJar, e);
            }
            Path metaInf = this.appClassesDir.resolve(META_INF);
            IoUtils.recursiveDelete((Path)metaInf.resolve("maven"));
            IoUtils.recursiveDelete((Path)metaInf.resolve("INDEX.LIST"));
            IoUtils.recursiveDelete((Path)metaInf.resolve("MANIFEST.MF"));
        }
        if (this.configDir == null) {
            this.configDir = this.appClassesDir;
        } else {
            try {
                if (Files.exists(this.configDir, new LinkOption[0]) && !Files.isSameFile(this.configDir, this.appClassesDir)) {
                    Files.walkFileTree(this.configDir, new CopyDirVisitor(this.configDir, this.appClassesDir, StandardCopyOption.REPLACE_EXISTING));
                }
            }
            catch (IOException e) {
                throw new AppCreatorException("Failed while copying files from " + this.configDir + " to " + this.appClassesDir, e);
            }
        }
        this.transformedClassesDir = IoUtils.mkdirs((Path)(this.transformedClassesDir == null ? this.outputDir.resolve("transformed-classes") : this.transformedClassesDir));
        this.wiringClassesDir = IoUtils.mkdirs((Path)(this.wiringClassesDir == null ? this.outputDir.resolve("wiring-classes") : this.wiringClassesDir));
        this.doProcess(appState);
        ctx.pushOutcome(AugmentOutcome.class, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcess(CurateOutcome appState) throws AppCreatorException {
        block37: {
            List appDeps;
            Path config = this.configDir.resolve("application.properties");
            if (Files.exists(config, new LinkOption[0])) {
                try {
                    Config built = SmallRyeConfigProviderResolver.instance().getBuilder().addDefaultSources().addDiscoveredConverters().addDiscoveredSources().withSources(new ConfigSource[]{new PropertiesConfigSource(config.toUri().toURL())}).build();
                    SmallRyeConfigProviderResolver.instance().registerConfig(built, Thread.currentThread().getContextClassLoader());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            AppModelResolver depResolver = appState.getArtifactResolver();
            try {
                appDeps = appState.getEffectiveModel().getAllDependencies();
            }
            catch (BootstrapDependencyProcessingException e) {
                throw new AppCreatorException("Failed to resolve application build classpath", e);
            }
            URLClassLoader runnerClassLoader = null;
            try {
                BuildResult result;
                ArrayList<URL> cpUrls = new ArrayList<URL>(appDeps.size() + 1);
                cpUrls.add(this.appClassesDir.toUri().toURL());
                for (AppDependency appDep : appDeps) {
                    Path resolvedDep = depResolver.resolve(appDep.getArtifact());
                    cpUrls.add(resolvedDep.toUri().toURL());
                }
                runnerClassLoader = new URLClassLoader(cpUrls.toArray(new URL[cpUrls.size()]), this.getClass().getClassLoader());
                final Path wiringClassesDirectory = this.wiringClassesDir;
                ClassOutput classOutput = new ClassOutput(){

                    public void writeClass(boolean applicationClass, String className, byte[] data) throws IOException {
                        String location = className.replace('.', File.separatorChar);
                        Path p = wiringClassesDirectory.resolve(location + ".class");
                        Files.createDirectories(p.getParent(), new FileAttribute[0]);
                        try (OutputStream out = Files.newOutputStream(p, new OpenOption[0]);){
                            out.write(data);
                        }
                    }

                    public void writeResource(String name, byte[] data) throws IOException {
                        Path p = wiringClassesDirectory.resolve(name);
                        Files.createDirectories(p.getParent(), new FileAttribute[0]);
                        try (OutputStream out = Files.newOutputStream(p, new OpenOption[0]);){
                            out.write(data);
                        }
                    }

                    public Writer writeSource(String className) {
                        String location = className.replace('.', '/');
                        Path basePath = AugmentPhase.this.generatedSourcesDir;
                        if (basePath == null) {
                            return NullWriter.INSTANCE;
                        }
                        Path path = basePath.resolve("gizmo").resolve(location + ".zig");
                        try {
                            Files.createDirectories(path.getParent(), new FileAttribute[0]);
                            return Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                        }
                        catch (IOException e) {
                            throw new IllegalStateException("Failed to write source file", e);
                        }
                    }
                };
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(runnerClassLoader);
                    QuarkusAugmentor.Builder builder = QuarkusAugmentor.builder();
                    builder.setRoot(this.appClassesDir);
                    builder.setClassLoader((ClassLoader)runnerClassLoader);
                    builder.setOutput(classOutput);
                    builder.setBuildSystemProperties(this.buildSystemProperties);
                    builder.addFinal(BytecodeTransformerBuildItem.class).addFinal(ApplicationArchivesBuildItem.class).addFinal(MainClassBuildItem.class).addFinal(SubstrateOutputBuildItem.class);
                    result = builder.build().run();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
                List bytecodeTransformerBuildItems = result.consumeMulti(BytecodeTransformerBuildItem.class);
                this.transformedClassesByJar = new HashMap<Path, Set<String>>();
                if (bytecodeTransformerBuildItems.isEmpty()) break block37;
                ApplicationArchivesBuildItem appArchives = (ApplicationArchivesBuildItem)result.consume(ApplicationArchivesBuildItem.class);
                HashMap<String, List> bytecodeTransformers = new HashMap<String, List>(bytecodeTransformerBuildItems.size());
                for (BytecodeTransformerBuildItem i : bytecodeTransformerBuildItems) {
                    bytecodeTransformers.computeIfAbsent(i.getClassToTransform(), h -> new ArrayList()).add(i.getVisitorFunction());
                }
                ExecutorService executorPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
                ConcurrentLinkedDeque<Future<FutureEntry>> transformed = new ConcurrentLinkedDeque<Future<FutureEntry>>();
                try {
                    final URLClassLoader transformCl = runnerClassLoader;
                    for (Map.Entry entry : bytecodeTransformers.entrySet()) {
                        final String className = (String)entry.getKey();
                        ApplicationArchive archive = appArchives.containingArchive((String)entry.getKey());
                        if (archive != null) {
                            final List visitors = (List)entry.getValue();
                            final String classFileName = className.replace(".", "/") + ".class";
                            final Path path = archive.getChildPath(classFileName);
                            this.transformedClassesByJar.computeIfAbsent(archive.getArchiveLocation(), a -> new HashSet()).add(classFileName);
                            transformed.add(executorPool.submit(new Callable<FutureEntry>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public FutureEntry call() throws Exception {
                                    ClassLoader old = Thread.currentThread().getContextClassLoader();
                                    try {
                                        QuarkusClassWriter writer;
                                        Thread.currentThread().setContextClassLoader(transformCl);
                                        if (Files.size(path) > Integer.MAX_VALUE) {
                                            throw new RuntimeException("Can't process class files larger than Integer.MAX_VALUE bytes");
                                        }
                                        ClassReader cr = new ClassReader(Files.readAllBytes(path));
                                        QuarkusClassWriter visitor = writer = new QuarkusClassWriter(cr, 3);
                                        for (BiFunction i : visitors) {
                                            visitor = (ClassVisitor)i.apply(className, visitor);
                                        }
                                        cr.accept((ClassVisitor)visitor, 0);
                                        FutureEntry futureEntry = new FutureEntry(writer.toByteArray(), classFileName);
                                        return futureEntry;
                                    }
                                    finally {
                                        Thread.currentThread().setContextClassLoader(old);
                                    }
                                }
                            }));
                            continue;
                        }
                        log.warnf("Cannot transform %s as it's containing application archive could not be found.", entry.getKey());
                    }
                }
                finally {
                    executorPool.shutdown();
                }
                if (transformed.isEmpty()) break block37;
                for (Future future : transformed) {
                    FutureEntry res = (FutureEntry)future.get();
                    Path classFile = this.transformedClassesDir.resolve(res.location);
                    Files.createDirectories(classFile.getParent(), new FileAttribute[0]);
                    OutputStream out = Files.newOutputStream(classFile, new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        IoUtils.copy((OutputStream)out, (InputStream)new ByteArrayInputStream(res.data));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
            }
            catch (Exception e) {
                throw new AppCreatorException("Failed to augment application classes", e);
            }
            finally {
                if (runnerClassLoader != null) {
                    try {
                        runnerClassLoader.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)"Failed to close runner classloader", (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public String getConfigPropertyName() {
        return "augment";
    }

    @Override
    public PropertiesHandler<AugmentPhase> getPropertiesHandler() {
        return new MappedPropertiesHandler<AugmentPhase>(){

            @Override
            public AugmentPhase getTarget() {
                return AugmentPhase.this;
            }
        }.map("output", (t, value) -> t.setOutputDir(Paths.get(value, new String[0]))).map("classes", (t, value) -> t.setAppClassesDir(Paths.get(value, new String[0]))).map("transformed-classes", (t, value) -> t.setTransformedClassesDir(Paths.get(value, new String[0]))).map("wiring-classes", (t, value) -> t.setWiringClassesDir(Paths.get(value, new String[0]))).map("config", (t, value) -> t.setConfigDir(Paths.get(value, new String[0])));
    }

    public static class CopyDirVisitor
    extends SimpleFileVisitor<Path> {
        private final Path fromPath;
        private final Path toPath;
        private final CopyOption copyOption;

        public CopyDirVisitor(Path fromPath, Path toPath, CopyOption copyOption) {
            this.fromPath = fromPath;
            this.toPath = toPath;
            this.copyOption = copyOption;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path targetPath = this.toPath.resolve(this.fromPath.relativize(dir));
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createDirectory(targetPath, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.toPath.resolve(this.fromPath.relativize(file)), this.copyOption);
            return FileVisitResult.CONTINUE;
        }
    }

    private static final class FutureEntry {
        final byte[] data;
        final String location;

        private FutureEntry(byte[] data, String location) {
            this.data = data;
            this.location = location;
        }
    }
}

