/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.creator;

import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.creator.AppCreationPhase;
import io.quarkus.creator.AppCreatorException;
import io.quarkus.creator.config.reader.MappedPropertiesHandler;
import io.quarkus.creator.config.reader.PropertiesConfigReaderException;
import io.quarkus.creator.config.reader.PropertiesHandler;
import io.quarkus.creator.outcome.OutcomeResolver;
import io.quarkus.creator.outcome.OutcomeResolverFactory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public class AppCreator
implements AutoCloseable {
    private OutcomeResolver<AppCreator> outcomeResolver;
    private AppModelResolver artifactResolver;
    private Path appJar;
    private Path workDir;
    private boolean deleteTmpDir = true;
    protected Map<Class<?>, Object> outcomes = new HashMap();

    public static Builder builder() {
        return new Builder();
    }

    private AppCreator() {
    }

    private void setWorkDir(Path workDir) {
        if (workDir != null) {
            this.deleteTmpDir = false;
            this.workDir = workDir;
        } else {
            this.workDir = null;
            this.deleteTmpDir = true;
        }
    }

    public Path getWorkDir() {
        return this.workDir;
    }

    public AppModelResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public Path getAppJar() throws AppCreatorException {
        return this.appJar;
    }

    public <T> T resolveOutcome(Class<T> outcomeType) throws AppCreatorException {
        Object o = this.outcomes.get(outcomeType);
        if (o != null || this.outcomes.containsKey(outcomeType)) {
            return (T)o;
        }
        this.outcomeResolver.resolve(this, outcomeType);
        o = this.outcomes.get(outcomeType);
        if (o != null || this.outcomes.containsKey(outcomeType)) {
            return (T)o;
        }
        throw new AppCreatorException("Outcome of type " + outcomeType + " has not been provided");
    }

    public boolean isAvailable(Class<?> outcomeType) {
        return this.outcomes.containsKey(outcomeType);
    }

    public <T> T getOutcome(Class<T> outcomeType) {
        return (T)this.outcomes.get(outcomeType);
    }

    public <T> AppCreator pushOutcome(T outcome) throws AppCreatorException {
        this.pushOutcome(outcome.getClass(), outcome);
        return this;
    }

    public <T> AppCreator pushOutcome(Class<T> type, T value) throws AppCreatorException {
        if (this.outcomes.containsKey(type)) {
            throw new AppCreatorException("Outcome of type " + type.getName() + " has already been provided");
        }
        this.outcomes.put(type, value);
        return this;
    }

    public Path createWorkDir(String ... names) throws AppCreatorException {
        Path p = this.getWorkPath(names);
        try {
            Files.createDirectories(p, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new AppCreatorException("Failed to create directory " + p, e);
        }
        return p;
    }

    public Path getWorkPath(String ... names) {
        if (this.workDir == null) {
            this.workDir = IoUtils.createRandomTmpDir();
        }
        if (names.length == 0) {
            return this.workDir;
        }
        Path p = this.workDir;
        for (String name : names) {
            p = p.resolve(name);
        }
        return p;
    }

    @Override
    public void close() {
        if (this.deleteTmpDir) {
            IoUtils.recursiveDelete((Path)this.workDir);
        }
    }

    public static class Builder {
        private List<AppCreationPhase> phases = Collections.emptyList();
        private Path appJar;
        private Path workDir;
        private AppModelResolver modelResolver;

        private Builder() {
        }

        public Builder addPhase(AppCreationPhase<?> provider) {
            switch (this.phases.size()) {
                case 0: {
                    this.phases = Collections.singletonList(provider);
                    break;
                }
                case 1: {
                    AppCreationPhase first = this.phases.get(0);
                    this.phases = new ArrayList<AppCreationPhase>(2);
                    this.phases.add(first);
                }
                default: {
                    this.phases.add(provider);
                }
            }
            return this;
        }

        public Builder setWorkDir(Path dir) {
            this.workDir = dir;
            return this;
        }

        public Builder setModelResolver(AppModelResolver resolver) {
            this.modelResolver = resolver;
            return this;
        }

        public Builder setAppJar(Path appJar) throws AppCreatorException {
            this.appJar = appJar;
            return this;
        }

        public AppCreator build() throws AppCreatorException {
            AppCreator target = this.initAppCreator();
            OutcomeResolverFactory<AppCreator> resolverFactory = OutcomeResolverFactory.getInstance();
            Iterable<AppCreationPhase> i = this.phases.isEmpty() ? ServiceLoader.load(AppCreationPhase.class) : this.phases;
            for (AppCreationPhase provider : i) {
                resolverFactory.addProvider(provider);
            }
            target.outcomeResolver = resolverFactory.build();
            return target;
        }

        public PropertiesHandler<AppCreator> getPropertiesHandler() throws AppCreatorException {
            final AppCreator target = this.initAppCreator();
            final Iterable<AppCreationPhase> i = this.phases.isEmpty() ? ServiceLoader.load(AppCreationPhase.class) : this.phases;
            MappedPropertiesHandler<AppCreator> propsHandler = new MappedPropertiesHandler<AppCreator>(){

                @Override
                public AppCreator getTarget() throws PropertiesConfigReaderException {
                    OutcomeResolverFactory<AppCreator> resolverFactory = OutcomeResolverFactory.getInstance();
                    for (AppCreationPhase provider : i) {
                        try {
                            resolverFactory.addProvider(provider);
                        }
                        catch (AppCreatorException e) {
                            throw new PropertiesConfigReaderException("Failed to initialize outcome resolver", e);
                        }
                        this.map(provider.getConfigPropertyName(), provider.getPropertiesHandler(), (T flow, C nested) -> {});
                    }
                    target.outcomeResolver = resolverFactory.build();
                    return target;
                }
            }.map("output", (t, value) -> ((AppCreator)t).setWorkDir(Paths.get(value, new String[0])));
            return propsHandler;
        }

        private AppCreator initAppCreator() throws AppCreatorException {
            AppCreator target = new AppCreator();
            target.setWorkDir(this.workDir);
            target.artifactResolver = this.modelResolver;
            target.appJar = this.appJar;
            return target;
        }
    }
}

