/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.creator.config.reader;

public class PropertyLine
implements Comparable<PropertyLine> {
    protected final String line;
    protected final int index;
    protected final String name;
    protected final String[] nameElements;
    protected final String value;

    public PropertyLine(String name, String value) {
        this(null, -1, name, name.split("\\."), value);
    }

    public PropertyLine(String line, int index, String name, String[] nameElements, String value) {
        this.line = line;
        this.index = index;
        this.name = name;
        this.nameElements = nameElements;
        this.value = value;
    }

    public String getLine() {
        return this.line;
    }

    public int getIndex() {
        return this.index;
    }

    public String[] getNameElements() {
        return this.nameElements;
    }

    public String getName() {
        return this.name;
    }

    public String getRelativeName(int nameElementIndex) {
        int lastIndex = this.nameElements.length - 1;
        if (nameElementIndex == lastIndex) {
            return this.nameElements[lastIndex];
        }
        if (nameElementIndex < 0 || nameElementIndex > lastIndex) {
            throw new IndexOutOfBoundsException("Name element index has to be in range from 0 to " + lastIndex + " but was " + nameElementIndex);
        }
        return this.getNamePart(nameElementIndex, lastIndex);
    }

    protected String getNamePart(int startI, int endI) {
        if (startI == endI) {
            return this.nameElements[startI];
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.nameElements[startI++]);
        while (startI <= endI) {
            buf.append('.').append(this.nameElements[startI++]);
        }
        return buf.toString();
    }

    public String getLastNameElement() {
        return this.nameElements[this.nameElements.length - 1];
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        if (this.index < 0) {
            return this.name + '=' + this.value;
        }
        return this.index + ") " + this.line;
    }

    @Override
    public int compareTo(PropertyLine o) {
        return this.name.compareTo(o.name);
    }
}

