/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.creator.outcome;

import io.quarkus.creator.outcome.OutcomeProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OutcomeProviderDescription<C> {
    static final int PROCESSING = 1;
    static final int PROCESSED = 2;
    protected final int id;
    protected final OutcomeProvider<C> provider;
    protected List<Class<?>> providedTypes = Collections.emptyList();
    private int flags;

    protected OutcomeProviderDescription(int id, OutcomeProvider<C> provider) {
        this.id = id;
        this.provider = provider;
    }

    protected void addProvidedType(Class<?> providedType) {
        if (this.providedTypes.isEmpty()) {
            this.providedTypes = new ArrayList(1);
        }
        this.providedTypes.add(providedType);
    }

    boolean isFlagOn(int flag) {
        return (this.flags & flag) > 0;
    }

    boolean setFlag(int flag) {
        if ((this.flags & flag) > 0) {
            return false;
        }
        this.flags ^= flag;
        return true;
    }

    void clearFlag(int flag) {
        if ((this.flags & flag) > 0) {
            this.flags ^= flag;
        }
    }
}

