/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.creator.outcome;

import io.quarkus.creator.AppCreatorException;
import io.quarkus.creator.outcome.Errors;
import io.quarkus.creator.outcome.OutcomeProvider;
import io.quarkus.creator.outcome.OutcomeProviderDescription;
import io.quarkus.creator.outcome.OutcomeProviderRegistration;
import io.quarkus.creator.outcome.OutcomeResolver;
import java.util.HashMap;
import java.util.Map;

public class OutcomeResolverFactory<C> {
    private Registration registration = new Registration();
    Map<Class<?>, OutcomeProviderDescription<C>> providers = new HashMap();

    public static <C> OutcomeResolverFactory<C> getInstance() {
        return new OutcomeResolverFactory<C>();
    }

    private OutcomeResolverFactory() {
    }

    public OutcomeResolverFactory<C> addProvider(OutcomeProvider<C> phaseHandler) throws AppCreatorException {
        this.registration.register(phaseHandler);
        return this;
    }

    public OutcomeResolver<C> build() {
        return new OutcomeResolver(this);
    }

    private class Registration
    implements OutcomeProviderRegistration {
        private int phasesTotal;
        OutcomeProviderDescription<C> phaseDescr;

        private Registration() {
        }

        void register(OutcomeProvider<C> handler) throws AppCreatorException {
            this.phaseDescr = new OutcomeProviderDescription(++this.phasesTotal, handler);
            handler.register(this);
        }

        @Override
        public void provides(Class<?> type) throws AppCreatorException {
            this.phaseDescr.addProvidedType(type);
            OutcomeProviderDescription duplicateDescr = OutcomeResolverFactory.this.providers.put(type, this.phaseDescr);
            if (duplicateDescr != null) {
                throw new AppCreatorException(Errors.alternativeOutcomeProviders(type, duplicateDescr.provider, this.phaseDescr.provider));
            }
        }
    }
}

