/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.creator.phase.generateconfig;

import io.quarkus.bootstrap.BootstrapDependencyProcessingException;
import io.quarkus.bootstrap.DefineClassVisibleURLClassLoader;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.builder.BuildChain;
import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildExecutionBuilder;
import io.quarkus.builder.BuildResult;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.creator.AppCreationPhase;
import io.quarkus.creator.AppCreator;
import io.quarkus.creator.AppCreatorException;
import io.quarkus.creator.config.reader.MappedPropertiesHandler;
import io.quarkus.creator.config.reader.PropertiesHandler;
import io.quarkus.creator.outcome.OutcomeProviderRegistration;
import io.quarkus.creator.phase.curate.CurateOutcome;
import io.quarkus.creator.phase.generateconfig.ConfigPhaseOutcome;
import io.quarkus.deployment.ExtensionLoader;
import io.quarkus.deployment.QuarkusConfig;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.ConfigDescriptionBuildItem;
import io.quarkus.deployment.builditem.ExtensionClassLoaderBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.runtime.LaunchMode;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

public class GenerateConfigPhase
implements AppCreationPhase<GenerateConfigPhase>,
ConfigPhaseOutcome {
    private static final Logger log = Logger.getLogger(GenerateConfigPhase.class);
    private Path configFile;

    public GenerateConfigPhase setConfigFile(Path configFile) {
        this.configFile = configFile;
        return this;
    }

    @Override
    public void register(OutcomeProviderRegistration registration) throws AppCreatorException {
        registration.provides(ConfigPhaseOutcome.class);
    }

    @Override
    public void provideOutcome(AppCreator ctx) throws AppCreatorException {
        CurateOutcome appState = ctx.resolveOutcome(CurateOutcome.class);
        this.doProcess(appState);
        ctx.pushOutcome(ConfigPhaseOutcome.class, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcess(CurateOutcome appState) throws AppCreatorException {
        List appDeps;
        if (Files.exists(this.configFile, new LinkOption[0])) {
            try {
                Config built = SmallRyeConfigProviderResolver.instance().getBuilder().addDefaultSources().addDiscoveredConverters().addDiscoveredSources().withSources(new ConfigSource[]{new PropertiesConfigSource(this.configFile.toUri().toURL())}).build();
                SmallRyeConfigProviderResolver.instance().registerConfig(built, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        AppModelResolver depResolver = appState.getArtifactResolver();
        try {
            appDeps = appState.getEffectiveModel().getAllDependencies();
        }
        catch (BootstrapDependencyProcessingException e) {
            throw new AppCreatorException("Failed to resolve application build classpath", e);
        }
        URLClassLoader runnerClassLoader = null;
        try {
            ArrayList<URL> cpUrls = new ArrayList<URL>(appDeps.size());
            for (AppDependency appDep : appDeps) {
                Path resolvedDep = depResolver.resolve(appDep.getArtifact());
                cpUrls.add(resolvedDep.toUri().toURL());
            }
            runnerClassLoader = new DefineClassVisibleURLClassLoader(cpUrls.toArray(new URL[cpUrls.size()]), this.getClass().getClassLoader());
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(runnerClassLoader);
                BuildChainBuilder chainBuilder = BuildChain.builder();
                ExtensionLoader.loadStepsFrom((ClassLoader)runnerClassLoader).accept(chainBuilder);
                chainBuilder.loadProviders((ClassLoader)runnerClassLoader);
                chainBuilder.addInitial(QuarkusConfig.class).addInitial(ShutdownContextBuildItem.class).addInitial(LaunchModeBuildItem.class).addInitial(ArchiveRootBuildItem.class).addInitial(LiveReloadBuildItem.class).addInitial(ExtensionClassLoaderBuildItem.class);
                chainBuilder.addFinal(ConfigDescriptionBuildItem.class);
                BuildChain chain = chainBuilder.build();
                BuildExecutionBuilder execBuilder = chain.createExecutionBuilder("main").produce((BuildItem)QuarkusConfig.INSTANCE).produce((BuildItem)new LaunchModeBuildItem(LaunchMode.NORMAL)).produce((BuildItem)new ShutdownContextBuildItem()).produce((BuildItem)new LiveReloadBuildItem()).produce((BuildItem)new ArchiveRootBuildItem(Files.createTempDirectory("empty", new FileAttribute[0]))).produce((BuildItem)new ExtensionClassLoaderBuildItem((ClassLoader)runnerClassLoader));
                BuildResult buildResult = execBuilder.execute();
                List descriptions = buildResult.consumeMulti(ConfigDescriptionBuildItem.class);
                Collections.sort(descriptions);
                String existing = "";
                if (Files.exists(this.configFile, new LinkOption[0])) {
                    FileInputStream in = new FileInputStream(this.configFile.toFile());
                    Object object = null;
                    try {
                        existing = new String(FileUtil.readFileContents((InputStream)in), StandardCharsets.UTF_8);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (in != null) {
                            if (object != null) {
                                try {
                                    ((InputStream)in).close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                ((InputStream)in).close();
                            }
                        }
                    }
                }
                StringBuilder sb = new StringBuilder();
                for (ConfigDescriptionBuildItem i : descriptions) {
                    if (existing.contains("\n" + i.getPropertyName() + "=") || existing.contains("\n#" + i.getPropertyName() + "=")) continue;
                    sb.append("\n#\n");
                    sb.append(this.formatDocs(i.getDocs()));
                    sb.append("\n#\n#");
                    sb.append(i.getPropertyName() + "=" + i.getDefaultValue());
                    sb.append("\n");
                }
                try (FileOutputStream out = new FileOutputStream(this.configFile.toFile(), true);){
                    out.write(sb.toString().getBytes(StandardCharsets.UTF_8));
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        catch (Exception e) {
            throw new AppCreatorException("Failed to generate config file", e);
        }
        finally {
            if (runnerClassLoader != null) {
                try {
                    runnerClassLoader.close();
                }
                catch (IOException e) {
                    log.warn((Object)"Failed to close runner classloader", (Throwable)e);
                }
            }
        }
    }

    private String formatDocs(String docs) {
        if (docs == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        boolean lastEmpty = false;
        boolean first = true;
        for (String line : docs.replace("<p>", "\n").split("\n")) {
            String trimmed = line.trim();
            if (trimmed.isEmpty()) {
                if (lastEmpty || first) continue;
                lastEmpty = true;
                builder.append("\n#");
                continue;
            }
            lastEmpty = false;
            if (first) {
                first = false;
            } else {
                builder.append("\n");
            }
            builder.append("# " + trimmed.replace("\n", "\n#").replace("<ul>", "").replace("</ul>", "").replace("<li>", " - ").replace("</li>", ""));
        }
        String ret = builder.toString();
        ret = Pattern.compile("\\{@code (.*?)\\}").matcher(ret).replaceAll("'$1'");
        Matcher matcher = Pattern.compile("\\{@link #(.*?)\\}").matcher(ret);
        while (matcher.find()) {
            ret = ret.replace(matcher.group(0), "'" + this.configify(matcher.group(1)) + "'");
        }
        return ret;
    }

    private String configify(String group) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < group.length(); ++i) {
            char c = group.charAt(i);
            if (Character.isUpperCase(c)) {
                ret.append("-");
                ret.append(Character.toLowerCase(c));
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    @Override
    public String getConfigPropertyName() {
        return "augment";
    }

    @Override
    public PropertiesHandler<GenerateConfigPhase> getPropertiesHandler() {
        return new MappedPropertiesHandler<GenerateConfigPhase>(){

            @Override
            public GenerateConfigPhase getTarget() {
                return GenerateConfigPhase.this;
            }
        }.map("configFile", (t, value) -> t.setConfigFile(Paths.get(value, new String[0])));
    }

    @Override
    public Path getConfigFile() {
        return this.configFile;
    }
}

