/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.csrf.reactive.runtime;

import io.quarkus.csrf.reactive.runtime.CsrfReactiveConfig;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.impl.CookieImpl;
import io.vertx.ext.web.RoutingContext;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.server.ServerRequestFilter;
import org.jboss.resteasy.reactive.server.ServerResponseFilter;

public class CsrfRequestResponseReactiveFilter {
    private static final Logger LOG = Logger.getLogger(CsrfRequestResponseReactiveFilter.class);
    private static final String CSRF_TOKEN_KEY = "csrf_token";
    private static final String CSRF_TOKEN_VERIFIED = "csrf_token_verified";
    @Inject
    Instance<CsrfReactiveConfig> configInstance;

    @ServerRequestFilter(preMatching=true)
    public Uni<Response> filter(ContainerRequestContext requestContext, final RoutingContext routing) {
        final CsrfReactiveConfig config = (CsrfReactiveConfig)this.configInstance.get();
        final String cookieToken = this.getCookieToken(routing, config);
        if (cookieToken != null) {
            routing.put(CSRF_TOKEN_KEY, (Object)cookieToken);
            try {
                int suppliedTokenSize = Base64.getUrlDecoder().decode(cookieToken).length;
                if (suppliedTokenSize != config.tokenSize) {
                    LOG.debugf("Invalid CSRF token cookie size: expected %d, got %d", config.tokenSize, suppliedTokenSize);
                    return Uni.createFrom().item((Object)CsrfRequestResponseReactiveFilter.badClientRequest());
                }
            }
            catch (IllegalArgumentException e) {
                LOG.debugf("Invalid CSRF token cookie: %s", (Object)cookieToken);
                return Uni.createFrom().item((Object)CsrfRequestResponseReactiveFilter.badClientRequest());
            }
        }
        if (CsrfRequestResponseReactiveFilter.requestMethodIsSafe(requestContext)) {
            if (cookieToken == null && this.isCsrfTokenRequired(routing, config)) {
                byte[] token = new byte[config.tokenSize];
                new SecureRandom().nextBytes(token);
                routing.put(CSRF_TOKEN_KEY, (Object)Base64.getUrlEncoder().withoutPadding().encodeToString(token));
            }
        } else {
            if (config.verifyToken) {
                if (!CsrfRequestResponseReactiveFilter.isMatchingMediaType(requestContext.getMediaType(), MediaType.APPLICATION_FORM_URLENCODED_TYPE) && !CsrfRequestResponseReactiveFilter.isMatchingMediaType(requestContext.getMediaType(), MediaType.MULTIPART_FORM_DATA_TYPE)) {
                    if (config.requireFormUrlEncoded) {
                        LOG.debugf("Request has the wrong media type: %s", (Object)requestContext.getMediaType().toString());
                        return Uni.createFrom().item((Object)CsrfRequestResponseReactiveFilter.badClientRequest());
                    }
                    LOG.debugf("Request has the  media type: %s, skipping the token verification", (Object)requestContext.getMediaType().toString());
                    return Uni.createFrom().nullItem();
                }
                if (!requestContext.hasEntity()) {
                    LOG.debug((Object)"Request has no entity");
                    return Uni.createFrom().item((Object)CsrfRequestResponseReactiveFilter.badClientRequest());
                }
                if (cookieToken == null) {
                    LOG.debug((Object)"CSRF cookie is not found");
                    return Uni.createFrom().item((Object)CsrfRequestResponseReactiveFilter.badClientRequest());
                }
                return CsrfRequestResponseReactiveFilter.getFormUrlEncodedData(routing.request()).flatMap((Function)new Function<MultiMap, Uni<? extends Response>>(){

                    @Override
                    public Uni<Response> apply(MultiMap form) {
                        String csrfToken = form.get(config.formFieldName);
                        if (csrfToken == null) {
                            LOG.debug((Object)"CSRF token is not found");
                            return Uni.createFrom().item((Object)CsrfRequestResponseReactiveFilter.badClientRequest());
                        }
                        if (!csrfToken.equals(cookieToken)) {
                            LOG.debug((Object)"CSRF token value is wrong");
                            return Uni.createFrom().item((Object)CsrfRequestResponseReactiveFilter.badClientRequest());
                        }
                        routing.put(CsrfRequestResponseReactiveFilter.CSRF_TOKEN_VERIFIED, (Object)true);
                        return Uni.createFrom().nullItem();
                    }
                });
            }
            if (cookieToken == null) {
                LOG.debug((Object)"CSRF token is not found");
                return Uni.createFrom().item((Object)CsrfRequestResponseReactiveFilter.badClientRequest());
            }
        }
        return null;
    }

    private static boolean isMatchingMediaType(MediaType contentType, MediaType expectedType) {
        return contentType.getType().equals(expectedType.getType()) && contentType.getSubtype().equals(expectedType.getSubtype());
    }

    private static Response badClientRequest() {
        return Response.status((int)400).build();
    }

    @ServerResponseFilter
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext, RoutingContext routing) {
        CsrfReactiveConfig config = (CsrfReactiveConfig)this.configInstance.get();
        if (requestContext.getMethod().equals("GET") && this.isCsrfTokenRequired(routing, config) && this.getCookieToken(routing, config) == null) {
            String token = (String)routing.get(CSRF_TOKEN_KEY);
            if (token == null) {
                throw new IllegalStateException("CSRF Filter should have set the property csrf_token, but it is null");
            }
            this.createCookie(token, routing, config);
        }
    }

    private String getCookieToken(RoutingContext routing, CsrfReactiveConfig config) {
        Cookie cookie = routing.getCookie(config.cookieName);
        if (cookie == null) {
            LOG.debug((Object)"CSRF token cookie is not set");
            return null;
        }
        return cookie.getValue();
    }

    private boolean isCsrfTokenRequired(RoutingContext routing, CsrfReactiveConfig config) {
        return config.createTokenPath.map(value -> value.contains(routing.normalizedPath())).orElse(true);
    }

    private void createCookie(String csrfToken, RoutingContext routing, CsrfReactiveConfig config) {
        CookieImpl cookie = new CookieImpl(config.cookieName, csrfToken);
        cookie.setHttpOnly(true);
        cookie.setSecure(config.cookieForceSecure || routing.request().isSSL());
        cookie.setMaxAge(config.cookieMaxAge.toSeconds());
        cookie.setPath(config.cookiePath);
        if (config.cookieDomain.isPresent()) {
            cookie.setDomain(config.cookieDomain.get());
        }
        routing.response().addCookie((Cookie)cookie);
    }

    private static boolean requestMethodIsSafe(ContainerRequestContext context) {
        switch (context.getMethod()) {
            case "GET": 
            case "HEAD": 
            case "OPTIONS": {
                return true;
            }
        }
        return false;
    }

    private static Uni<MultiMap> getFormUrlEncodedData(final HttpServerRequest request) {
        request.setExpectMultipart(true);
        return Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super MultiMap>>(){

            @Override
            public void accept(final UniEmitter<? super MultiMap> t) {
                request.endHandler((Handler)new Handler<Void>(){

                    public void handle(Void event) {
                        t.complete((Object)request.formAttributes());
                    }
                });
                request.resume();
            }
        });
    }
}

