/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.csrf.reactive.runtime;

import io.quarkus.csrf.reactive.runtime.CsrfReactiveConfig;
import io.quarkus.csrf.reactive.runtime.CsrfTokenUtils;
import io.vertx.core.http.Cookie;
import io.vertx.ext.web.RoutingContext;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.security.SecureRandom;
import java.util.Base64;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.jaxrs.ContainerRequestContextImpl;
import org.jboss.resteasy.reactive.server.spi.GenericRuntimeConfigurableServerRestHandler;

public class CsrfHandler
implements GenericRuntimeConfigurableServerRestHandler<CsrfReactiveConfig> {
    private static final Logger LOG = Logger.getLogger(CsrfHandler.class);
    private static final String CSRF_TOKEN_KEY = "csrf_token";
    private static final String CSRF_TOKEN_BYTES_KEY = "csrf_token_bytes";
    private static final String CSRF_TOKEN_VERIFIED = "csrf_token_verified";
    private volatile SecureRandom secureRandom;
    private static final VarHandle SECURE_RANDOM_VH;
    private CsrfReactiveConfig config;

    public void handle(ResteasyReactiveRequestContext reactiveRequestContext) {
        ContainerRequestContextImpl requestContext = reactiveRequestContext.getContainerRequestContext();
        RoutingContext routing = (RoutingContext)reactiveRequestContext.serverRequest().unwrap(RoutingContext.class);
        String cookieToken = this.getCookieToken(routing, this.config);
        if (cookieToken != null) {
            routing.put(CSRF_TOKEN_KEY, (Object)cookieToken);
            try {
                int expectedCookieTokenSize;
                int cookieTokenSize = Base64.getUrlDecoder().decode(cookieToken).length;
                int n = expectedCookieTokenSize = this.config.tokenSignatureKey.isPresent() ? 32 : this.config.tokenSize;
                if (cookieTokenSize != expectedCookieTokenSize) {
                    LOG.debugf("Invalid CSRF token cookie size: expected %d, got %d", expectedCookieTokenSize, cookieTokenSize);
                    requestContext.abortWith(CsrfHandler.badClientRequest());
                    return;
                }
            }
            catch (IllegalArgumentException e) {
                LOG.debugf("Invalid CSRF token cookie: %s", (Object)cookieToken);
                requestContext.abortWith(CsrfHandler.badClientRequest());
                return;
            }
        }
        if (CsrfHandler.requestMethodIsSafe((ContainerRequestContext)requestContext)) {
            if (cookieToken == null && this.isCsrfTokenRequired(routing, this.config)) {
                byte[] tokenBytes = new byte[this.config.tokenSize];
                this.getSecureRandom().nextBytes(tokenBytes);
                routing.put(CSRF_TOKEN_BYTES_KEY, (Object)tokenBytes);
                routing.put(CSRF_TOKEN_KEY, (Object)Base64.getUrlEncoder().withoutPadding().encodeToString(tokenBytes));
            }
        } else if (this.config.verifyToken) {
            String expectedCookieTokenValue;
            if (!CsrfHandler.isMatchingMediaType(requestContext.getMediaType(), MediaType.APPLICATION_FORM_URLENCODED_TYPE) && !CsrfHandler.isMatchingMediaType(requestContext.getMediaType(), MediaType.MULTIPART_FORM_DATA_TYPE)) {
                if (this.config.requireFormUrlEncoded) {
                    LOG.debugf("Request has the wrong media type: %s", (Object)requestContext.getMediaType().toString());
                    requestContext.abortWith(CsrfHandler.badClientRequest());
                    return;
                }
                LOG.debugf("Request has the  media type: %s, skipping the token verification", (Object)requestContext.getMediaType().toString());
                requestContext.abortWith(CsrfHandler.badClientRequest());
                return;
            }
            if (!requestContext.hasEntity()) {
                LOG.debug((Object)"Request has no entity");
                requestContext.abortWith(CsrfHandler.badClientRequest());
                return;
            }
            if (cookieToken == null) {
                LOG.debug((Object)"CSRF cookie is not found");
                requestContext.abortWith(CsrfHandler.badClientRequest());
                return;
            }
            String csrfToken = (String)reactiveRequestContext.getFormParameter(this.config.formFieldName, true, true);
            if (csrfToken == null) {
                LOG.debug((Object)"CSRF token is not found");
                requestContext.abortWith(CsrfHandler.badClientRequest());
                return;
            }
            String string = expectedCookieTokenValue = this.config.tokenSignatureKey.isPresent() ? CsrfTokenUtils.signCsrfToken(csrfToken, this.config.tokenSignatureKey.get()) : csrfToken;
            if (!cookieToken.equals(expectedCookieTokenValue)) {
                LOG.debug((Object)"CSRF token value is wrong");
                requestContext.abortWith(CsrfHandler.badClientRequest());
                return;
            }
            routing.put(CSRF_TOKEN_VERIFIED, (Object)true);
        } else if (cookieToken == null) {
            LOG.debug((Object)"CSRF token is not found");
            requestContext.abortWith(CsrfHandler.badClientRequest());
        }
    }

    private SecureRandom getSecureRandom() {
        return SECURE_RANDOM_VH.getAcquire(this);
    }

    private static boolean isMatchingMediaType(MediaType contentType, MediaType expectedType) {
        return contentType.getType().equals(expectedType.getType()) && contentType.getSubtype().equals(expectedType.getSubtype());
    }

    private static Response badClientRequest() {
        return Response.status((int)400).build();
    }

    private String getCookieToken(RoutingContext routing, CsrfReactiveConfig config) {
        Cookie cookie = routing.getCookie(config.cookieName);
        if (cookie == null) {
            LOG.debug((Object)"CSRF token cookie is not set");
            return null;
        }
        return cookie.getValue();
    }

    private boolean isCsrfTokenRequired(RoutingContext routing, CsrfReactiveConfig config) {
        return config.createTokenPath.isPresent() ? config.createTokenPath.get().contains(routing.request().path()) : true;
    }

    private static boolean requestMethodIsSafe(ContainerRequestContext context) {
        switch (context.getMethod()) {
            case "GET": 
            case "HEAD": 
            case "OPTIONS": {
                return true;
            }
        }
        return false;
    }

    public void configure(CsrfReactiveConfig configuration) {
        this.config = configuration;
        SECURE_RANDOM_VH.setRelease(this, new SecureRandom());
    }

    public Class<CsrfReactiveConfig> getConfigurationClass() {
        return CsrfReactiveConfig.class;
    }

    static {
        try {
            SECURE_RANDOM_VH = MethodHandles.lookup().findVarHandle(CsrfHandler.class, "secureRandom", SecureRandom.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new Error(e);
        }
    }
}

