/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.csrf.reactive.runtime;

import io.quarkus.csrf.reactive.runtime.CsrfReactiveConfig;
import io.quarkus.csrf.reactive.runtime.CsrfTokenUtils;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.impl.CookieImpl;
import io.vertx.ext.web.RoutingContext;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.server.ServerResponseFilter;

public class CsrfResponseFilter {
    private static final Logger LOG = Logger.getLogger(CsrfResponseFilter.class);
    private static final String CSRF_TOKEN_KEY = "csrf_token";
    private static final String CSRF_TOKEN_BYTES_KEY = "csrf_token_bytes";
    @Inject
    Instance<CsrfReactiveConfig> config;

    @ServerResponseFilter
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext, RoutingContext routing) {
        if (requestContext.getMethod().equals("GET") && this.isCsrfTokenRequired(routing, (CsrfReactiveConfig)this.config.get()) && this.getCookieToken(routing, (CsrfReactiveConfig)this.config.get()) == null) {
            String cookieValue = null;
            if (((CsrfReactiveConfig)this.config.get()).tokenSignatureKey.isPresent()) {
                byte[] csrfTokenBytes = (byte[])routing.get(CSRF_TOKEN_BYTES_KEY);
                if (csrfTokenBytes == null) {
                    throw new IllegalStateException("CSRF Filter should have set the property csrf_token, but it is null");
                }
                cookieValue = CsrfTokenUtils.signCsrfToken(csrfTokenBytes, ((CsrfReactiveConfig)this.config.get()).tokenSignatureKey.get());
            } else {
                String csrfToken = (String)routing.get(CSRF_TOKEN_KEY);
                if (csrfToken == null) {
                    throw new IllegalStateException("CSRF Filter should have set the property csrf_token, but it is null");
                }
                cookieValue = csrfToken;
            }
            this.createCookie(cookieValue, routing, (CsrfReactiveConfig)this.config.get());
        }
    }

    private String getCookieToken(RoutingContext routing, CsrfReactiveConfig config) {
        Cookie cookie = routing.getCookie(config.cookieName);
        if (cookie == null) {
            LOG.debug((Object)"CSRF token cookie is not set");
            return null;
        }
        return cookie.getValue();
    }

    private boolean isCsrfTokenRequired(RoutingContext routing, CsrfReactiveConfig config) {
        return config.createTokenPath.isPresent() ? config.createTokenPath.get().contains(routing.request().path()) : true;
    }

    private void createCookie(String csrfToken, RoutingContext routing, CsrfReactiveConfig config) {
        CookieImpl cookie = new CookieImpl(config.cookieName, csrfToken);
        cookie.setHttpOnly(true);
        cookie.setSecure(config.cookieForceSecure || routing.request().isSSL());
        cookie.setMaxAge(config.cookieMaxAge.toSeconds());
        cookie.setPath(config.cookiePath);
        if (config.cookieDomain.isPresent()) {
            cookie.setDomain(config.cookieDomain.get());
        }
        routing.response().addCookie((Cookie)cookie);
    }
}

