/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.csrf.reactive.runtime;

import io.quarkus.csrf.reactive.runtime.CsrfReactiveConfig;
import io.quarkus.csrf.reactive.runtime.CsrfTokenUtils;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.impl.CookieImpl;
import io.vertx.ext.web.RoutingContext;
import java.security.SecureRandom;
import java.util.Base64;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.server.ServerRequestFilter;
import org.jboss.resteasy.reactive.server.ServerResponseFilter;
import org.jboss.resteasy.reactive.server.WithFormRead;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerRequestContext;

public class CsrfRequestResponseReactiveFilter {
    private static final Logger LOG = Logger.getLogger(CsrfRequestResponseReactiveFilter.class);
    private static final String CSRF_TOKEN_KEY = "csrf_token";
    private static final String CSRF_TOKEN_BYTES_KEY = "csrf_token_bytes";
    private static final String CSRF_TOKEN_VERIFIED = "csrf_token_verified";
    private final SecureRandom secureRandom = new SecureRandom();
    @Inject
    Instance<CsrfReactiveConfig> configInstance;

    @ServerRequestFilter
    @WithFormRead
    public void filter(ResteasyReactiveContainerRequestContext requestContext, RoutingContext routing) {
        CsrfReactiveConfig config = (CsrfReactiveConfig)this.configInstance.get();
        String cookieToken = this.getCookieToken(routing, config);
        if (cookieToken != null) {
            routing.put(CSRF_TOKEN_KEY, (Object)cookieToken);
            try {
                int expectedCookieTokenSize;
                int cookieTokenSize = Base64.getUrlDecoder().decode(cookieToken).length;
                int n = expectedCookieTokenSize = config.tokenSignatureKey.isPresent() ? 32 : config.tokenSize;
                if (cookieTokenSize != expectedCookieTokenSize) {
                    LOG.debugf("Invalid CSRF token cookie size: expected %d, got %d", expectedCookieTokenSize, cookieTokenSize);
                    requestContext.abortWith(CsrfRequestResponseReactiveFilter.badClientRequest());
                    return;
                }
            }
            catch (IllegalArgumentException e) {
                LOG.debugf("Invalid CSRF token cookie: %s", (Object)cookieToken);
                requestContext.abortWith(CsrfRequestResponseReactiveFilter.badClientRequest());
                return;
            }
        }
        if (CsrfRequestResponseReactiveFilter.requestMethodIsSafe((ContainerRequestContext)requestContext)) {
            if (cookieToken == null && this.isCsrfTokenRequired(routing, config)) {
                byte[] tokenBytes = new byte[config.tokenSize];
                this.secureRandom.nextBytes(tokenBytes);
                routing.put(CSRF_TOKEN_BYTES_KEY, (Object)tokenBytes);
                routing.put(CSRF_TOKEN_KEY, (Object)Base64.getUrlEncoder().withoutPadding().encodeToString(tokenBytes));
            }
        } else {
            if (config.verifyToken) {
                String expectedCookieTokenValue;
                if (!CsrfRequestResponseReactiveFilter.isMatchingMediaType(requestContext.getMediaType(), MediaType.APPLICATION_FORM_URLENCODED_TYPE) && !CsrfRequestResponseReactiveFilter.isMatchingMediaType(requestContext.getMediaType(), MediaType.MULTIPART_FORM_DATA_TYPE)) {
                    if (config.requireFormUrlEncoded) {
                        LOG.debugf("Request has the wrong media type: %s", (Object)requestContext.getMediaType().toString());
                        requestContext.abortWith(CsrfRequestResponseReactiveFilter.badClientRequest());
                        return;
                    }
                    LOG.debugf("Request has the  media type: %s, skipping the token verification", (Object)requestContext.getMediaType().toString());
                    return;
                }
                if (!requestContext.hasEntity()) {
                    LOG.debug((Object)"Request has no entity");
                    requestContext.abortWith(CsrfRequestResponseReactiveFilter.badClientRequest());
                    return;
                }
                if (cookieToken == null) {
                    LOG.debug((Object)"CSRF cookie is not found");
                    requestContext.abortWith(CsrfRequestResponseReactiveFilter.badClientRequest());
                    return;
                }
                ResteasyReactiveRequestContext rrContext = (ResteasyReactiveRequestContext)requestContext.getServerRequestContext();
                String csrfToken = (String)rrContext.getFormParameter(config.formFieldName, true, false);
                if (csrfToken == null) {
                    LOG.debug((Object)"CSRF token is not found");
                    requestContext.abortWith(CsrfRequestResponseReactiveFilter.badClientRequest());
                    return;
                }
                String string = expectedCookieTokenValue = config.tokenSignatureKey.isPresent() ? CsrfTokenUtils.signCsrfToken(csrfToken, config.tokenSignatureKey.get()) : csrfToken;
                if (!cookieToken.equals(expectedCookieTokenValue)) {
                    LOG.debug((Object)"CSRF token value is wrong");
                    requestContext.abortWith(CsrfRequestResponseReactiveFilter.badClientRequest());
                    return;
                }
                routing.put(CSRF_TOKEN_VERIFIED, (Object)true);
                return;
            }
            if (cookieToken == null) {
                LOG.debug((Object)"CSRF token is not found");
                requestContext.abortWith(CsrfRequestResponseReactiveFilter.badClientRequest());
            }
        }
    }

    private static boolean isMatchingMediaType(MediaType contentType, MediaType expectedType) {
        return contentType.getType().equals(expectedType.getType()) && contentType.getSubtype().equals(expectedType.getSubtype());
    }

    private static Response badClientRequest() {
        return Response.status((int)400).build();
    }

    @ServerResponseFilter
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext, RoutingContext routing) {
        CsrfReactiveConfig config = (CsrfReactiveConfig)this.configInstance.get();
        if (requestContext.getMethod().equals("GET") && this.isCsrfTokenRequired(routing, config) && this.getCookieToken(routing, config) == null) {
            String cookieValue = null;
            if (config.tokenSignatureKey.isPresent()) {
                byte[] csrfTokenBytes = (byte[])routing.get(CSRF_TOKEN_BYTES_KEY);
                if (csrfTokenBytes == null) {
                    throw new IllegalStateException("CSRF Filter should have set the property csrf_token, but it is null");
                }
                cookieValue = CsrfTokenUtils.signCsrfToken(csrfTokenBytes, config.tokenSignatureKey.get());
            } else {
                String csrfToken = (String)routing.get(CSRF_TOKEN_KEY);
                if (csrfToken == null) {
                    throw new IllegalStateException("CSRF Filter should have set the property csrf_token, but it is null");
                }
                cookieValue = csrfToken;
            }
            this.createCookie(cookieValue, routing, config);
        }
    }

    private String getCookieToken(RoutingContext routing, CsrfReactiveConfig config) {
        Cookie cookie = routing.getCookie(config.cookieName);
        if (cookie == null) {
            LOG.debug((Object)"CSRF token cookie is not set");
            return null;
        }
        return cookie.getValue();
    }

    private boolean isCsrfTokenRequired(RoutingContext routing, CsrfReactiveConfig config) {
        return config.createTokenPath.isPresent() ? config.createTokenPath.get().contains(routing.request().path()) : true;
    }

    private void createCookie(String csrfToken, RoutingContext routing, CsrfReactiveConfig config) {
        CookieImpl cookie = new CookieImpl(config.cookieName, csrfToken);
        cookie.setHttpOnly(true);
        cookie.setSecure(config.cookieForceSecure || routing.request().isSSL());
        cookie.setMaxAge(config.cookieMaxAge.toSeconds());
        cookie.setPath(config.cookiePath);
        if (config.cookieDomain.isPresent()) {
            cookie.setDomain(config.cookieDomain.get());
        }
        routing.response().addCookie((Cookie)cookie);
    }

    private static boolean requestMethodIsSafe(ContainerRequestContext context) {
        switch (context.getMethod()) {
            case "GET": 
            case "HEAD": 
            case "OPTIONS": {
                return true;
            }
        }
        return false;
    }
}

