/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.csrf.reactive.runtime;

import io.quarkus.csrf.reactive.runtime.CsrfReactiveConfig;
import io.vertx.ext.web.RoutingContext;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;

@ApplicationScoped
@Named(value="csrf")
public class CsrfTokenParameterProvider {
    private static final String CSRF_TOKEN_KEY = "csrf_token";
    @Inject
    RoutingContext context;
    private final String csrfFormFieldName;

    public CsrfTokenParameterProvider(CsrfReactiveConfig config) {
        this.csrfFormFieldName = config.formFieldName;
    }

    public String getToken() {
        String token = (String)this.context.get(CSRF_TOKEN_KEY);
        if (token == null) {
            throw new IllegalStateException("CSRFFilter should have set the attribute " + this.csrfFormFieldName + ", but it is null");
        }
        return token;
    }

    public String getParameterName() {
        return this.csrfFormFieldName;
    }
}

