/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cyclonedx.deployment;

import io.quarkus.bootstrap.app.DependencyInfoProvider;
import io.quarkus.bootstrap.app.SbomResult;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.cyclonedx.deployment.CycloneDxConfig;
import io.quarkus.cyclonedx.generator.CycloneDxSbomGenerator;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AppModelProviderBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.sbom.ApplicationManifestsBuildItem;
import io.quarkus.deployment.sbom.SbomBuildItem;
import io.quarkus.sbom.ApplicationManifest;

public class CdxSbomBuildStep {
    @BuildStep
    public void generate(ApplicationManifestsBuildItem applicationManifestsBuildItem, OutputTargetBuildItem outputTargetBuildItem, AppModelProviderBuildItem appModelProviderBuildItem, CycloneDxConfig cdxSbomConfig, BuildProducer<SbomBuildItem> sbomProducer) {
        if (cdxSbomConfig.skip() || applicationManifestsBuildItem.getManifests().isEmpty()) {
            return;
        }
        DependencyInfoProvider depInfoProvider = (DependencyInfoProvider)appModelProviderBuildItem.getDependencyInfoProvider().get();
        for (ApplicationManifest manifest : applicationManifestsBuildItem.getManifests()) {
            for (SbomResult sbom : CycloneDxSbomGenerator.newInstance().setManifest(manifest).setOutputDirectory(outputTargetBuildItem.getOutputDirectory()).setEffectiveModelResolver(depInfoProvider == null ? null : depInfoProvider.getMavenModelResolver()).setFormat(cdxSbomConfig.format()).setSchemaVersion((String)cdxSbomConfig.schemaVersion().orElse(null)).setIncludeLicenseText(cdxSbomConfig.includeLicenseText()).generate()) {
                sbomProducer.produce((BuildItem)new SbomBuildItem(sbom));
            }
        }
    }
}

