/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.datasource.deployment.spi;

import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.datasource.common.runtime.DatabaseKind;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.util.ArtifactInfoUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class DefaultDataSourceDbKindBuildItem
extends MultiBuildItem {
    public static final String TEST = "test";
    private final String dbKind;
    private final Class<?> callerClass;
    private volatile String scope;

    public DefaultDataSourceDbKindBuildItem(String dbKind) {
        this.dbKind = dbKind;
        String callerClassName = new RuntimeException().getStackTrace()[1].getClassName();
        try {
            this.callerClass = Thread.currentThread().getContextClassLoader().loadClass(callerClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDbKind() {
        return this.dbKind;
    }

    public String getScope(CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (this.scope == null) {
            Map.Entry artifact = ArtifactInfoUtil.groupIdAndArtifactId(this.callerClass, (CurateOutcomeBuildItem)curateOutcomeBuildItem);
            for (AppDependency i : curateOutcomeBuildItem.getEffectiveModel().getFullDeploymentDeps()) {
                if (!i.getArtifact().getArtifactId().equals(artifact.getValue()) || !i.getArtifact().getGroupId().equals(artifact.getKey())) continue;
                this.scope = i.getScope();
                break;
            }
            if (this.scope == null) {
                throw new RuntimeException("Could not determine scope for " + this.dbKind);
            }
        }
        return this.scope;
    }

    public static Optional<String> resolve(Optional<String> configured, List<DefaultDataSourceDbKindBuildItem> defaultDbKinds, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (configured.isPresent()) {
            return Optional.of(DatabaseKind.normalize((String)configured.get()));
        }
        return DefaultDataSourceDbKindBuildItem.resolve(defaultDbKinds, curateOutcomeBuildItem);
    }

    public static Optional<String> resolve(List<DefaultDataSourceDbKindBuildItem> defaultDbKinds, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (defaultDbKinds.isEmpty()) {
            return Optional.empty();
        }
        if (defaultDbKinds.size() == 1) {
            return Optional.of(defaultDbKinds.get((int)0).dbKind);
        }
        DefaultDataSourceDbKindBuildItem testScopedDriver = null;
        for (DefaultDataSourceDbKindBuildItem i : defaultDbKinds) {
            if (!i.getScope(curateOutcomeBuildItem).equals(TEST)) continue;
            if (testScopedDriver == null) {
                testScopedDriver = i;
                continue;
            }
            return Optional.empty();
        }
        if (testScopedDriver == null) {
            return Optional.empty();
        }
        return Optional.of(testScopedDriver.dbKind);
    }
}

