/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.datasource.deployment.spi;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.eclipse.microprofile.config.ConfigProvider;

public final class DevServicesDatasourceConfigurationHandlerBuildItem
extends MultiBuildItem {
    private final String dbKind;
    private final BiFunction<String, DevServicesDatasourceProvider.RunningDevServicesDatasource, Map<String, String>> configProviderFunction;
    private final Predicate<String> checkConfiguredFunction;

    public DevServicesDatasourceConfigurationHandlerBuildItem(String dbKind, BiFunction<String, DevServicesDatasourceProvider.RunningDevServicesDatasource, Map<String, String>> configProviderFunction, Predicate<String> checkConfiguredFunction) {
        this.dbKind = dbKind;
        this.configProviderFunction = configProviderFunction;
        this.checkConfiguredFunction = checkConfiguredFunction;
    }

    public BiFunction<String, DevServicesDatasourceProvider.RunningDevServicesDatasource, Map<String, String>> getConfigProviderFunction() {
        return this.configProviderFunction;
    }

    public String getDbKind() {
        return this.dbKind;
    }

    public Predicate<String> getCheckConfiguredFunction() {
        return this.checkConfiguredFunction;
    }

    public static DevServicesDatasourceConfigurationHandlerBuildItem jdbc(String dbKind) {
        return new DevServicesDatasourceConfigurationHandlerBuildItem(dbKind, new BiFunction<String, DevServicesDatasourceProvider.RunningDevServicesDatasource, Map<String, String>>(){

            @Override
            public Map<String, String> apply(String dsName, DevServicesDatasourceProvider.RunningDevServicesDatasource runningDevDb) {
                if (dsName == null) {
                    return Collections.singletonMap("quarkus.datasource.jdbc.url", runningDevDb.getUrl());
                }
                return Collections.singletonMap("quarkus.datasource.\"" + dsName + "\".jdbc.url", runningDevDb.getUrl());
            }
        }, new Predicate<String>(){

            @Override
            public boolean test(String dsName) {
                if (dsName == null) {
                    return ConfigProvider.getConfig().getOptionalValue("quarkus.datasource.jdbc.url", String.class).isPresent();
                }
                return ConfigProvider.getConfig().getOptionalValue("quarkus.datasource.\"" + dsName + "\".jdbc.url", String.class).isPresent() || ConfigProvider.getConfig().getOptionalValue("quarkus.datasource." + dsName + ".jdbc.url", String.class).isPresent();
            }
        });
    }

    public static DevServicesDatasourceConfigurationHandlerBuildItem reactive(String dbKind) {
        return new DevServicesDatasourceConfigurationHandlerBuildItem(dbKind, new BiFunction<String, DevServicesDatasourceProvider.RunningDevServicesDatasource, Map<String, String>>(){

            @Override
            public Map<String, String> apply(String dsName, DevServicesDatasourceProvider.RunningDevServicesDatasource runningDevDb) {
                if (dsName == null) {
                    return Collections.singletonMap("quarkus.datasource.reactive.url", runningDevDb.getUrl().replaceFirst("jdbc:", "vertx-reactive:"));
                }
                return Collections.singletonMap("quarkus.datasource.\"" + dsName + "\".reactive.url", runningDevDb.getUrl().replaceFirst("jdbc:", "vertx-reactive:"));
            }
        }, new Predicate<String>(){

            @Override
            public boolean test(String dsName) {
                if (dsName == null) {
                    return ConfigProvider.getConfig().getOptionalValue("quarkus.datasource.reactive.url", String.class).isPresent();
                }
                return ConfigProvider.getConfig().getOptionalValue("quarkus.datasource.\"" + dsName + "\".reactive.url", String.class).isPresent();
            }
        });
    }
}

