/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.datasource.deployment.devservices;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.deployment.spi.DefaultDataSourceDbKindBuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceConfigurationHandlerBuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProviderBuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceResultBuildItem;
import io.quarkus.datasource.runtime.DataSourceBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class DevServicesDatasourceProcessor {
    private static final Logger log = Logger.getLogger(DevServicesDatasourceProcessor.class);
    static volatile List<Closeable> databases;
    static volatile Map<String, String> cachedProperties;
    static volatile boolean first;

    @BuildStep(onlyIfNot={IsNormal.class})
    DevServicesDatasourceResultBuildItem launchDatabases(CurateOutcomeBuildItem curateOutcomeBuildItem, List<DefaultDataSourceDbKindBuildItem> installedDrivers, List<DevServicesDatasourceProviderBuildItem> devDBProviders, DataSourcesBuildTimeConfig dataSourceBuildTimeConfig, LaunchModeBuildItem launchMode, BuildProducer<RunTimeConfigurationDefaultBuildItem> runTimeConfigurationDefaultBuildItemBuildProducer, List<DevServicesDatasourceConfigurationHandlerBuildItem> configurationHandlerBuildItems, BuildProducer<ServiceStartBuildItem> serviceStartBuildItemBuildProducer) {
        if (databases != null) {
            boolean restartRequired;
            boolean bl = restartRequired = launchMode.getLaunchMode() == LaunchMode.TEST;
            if (!restartRequired) {
                for (Map.Entry entry : cachedProperties.entrySet()) {
                    if (Objects.equals(entry.getValue(), ConfigProvider.getConfig().getOptionalValue((String)entry.getKey(), String.class).orElse(null))) continue;
                    restartRequired = true;
                    break;
                }
            }
            if (!restartRequired) {
                return null;
            }
            for (Closeable closeable : databases) {
                try {
                    closeable.close();
                }
                catch (Throwable e) {
                    log.error((Object)"Failed to stop database", e);
                }
            }
            databases = null;
            cachedProperties = null;
        }
        HashMap namedResults = new HashMap();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<Closeable> closeableList = new ArrayList<Closeable>();
        Map<String, List<DevServicesDatasourceConfigurationHandlerBuildItem>> configHandlersByDbType = configurationHandlerBuildItems.stream().collect(Collectors.toMap(DevServicesDatasourceConfigurationHandlerBuildItem::getDbKind, Collections::singletonList, (configurationHandlerBuildItems1, configurationHandlerBuildItems2) -> {
            ArrayList ret = new ArrayList();
            ret.addAll(configurationHandlerBuildItems1);
            ret.addAll(configurationHandlerBuildItems2);
            return ret;
        }));
        Map<String, DevServicesDatasourceProvider> devDBProviderMap = devDBProviders.stream().collect(Collectors.toMap(DevServicesDatasourceProviderBuildItem::getDatabase, DevServicesDatasourceProviderBuildItem::getDevServicesProvider));
        DevServicesDatasourceResultBuildItem.DbResult defaultResult = this.startDevDb(null, curateOutcomeBuildItem, installedDrivers, devDBProviderMap, dataSourceBuildTimeConfig.defaultDataSource, configHandlersByDbType, hashMap, closeableList);
        if (defaultResult != null) {
            for (Map.Entry i : defaultResult.getConfigProperties().entrySet()) {
                runTimeConfigurationDefaultBuildItemBuildProducer.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem((String)i.getKey(), (String)i.getValue()));
            }
        }
        for (Map.Entry entry : dataSourceBuildTimeConfig.namedDataSources.entrySet()) {
            DevServicesDatasourceResultBuildItem.DbResult result = this.startDevDb((String)entry.getKey(), curateOutcomeBuildItem, installedDrivers, devDBProviderMap, (DataSourceBuildTimeConfig)entry.getValue(), configHandlersByDbType, hashMap, closeableList);
            if (result == null) continue;
            namedResults.put(entry.getKey(), result);
            for (Map.Entry i : result.getConfigProperties().entrySet()) {
                runTimeConfigurationDefaultBuildItemBuildProducer.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem((String)i.getKey(), (String)i.getValue()));
            }
        }
        if (first) {
            first = false;
            Runnable closeTask = new Runnable(){

                @Override
                public void run() {
                    if (databases != null) {
                        for (Closeable i : databases) {
                            try {
                                i.close();
                            }
                            catch (Throwable t) {
                                log.error((Object)"Failed to stop database", t);
                            }
                        }
                    }
                    first = true;
                    databases = null;
                    cachedProperties = null;
                }
            };
            QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
            ((QuarkusClassLoader)cl.parent()).addCloseTask(closeTask);
            final Thread closeHookThread = new Thread(closeTask, "Database shutdown thread");
            Runtime.getRuntime().addShutdownHook(closeHookThread);
            ((QuarkusClassLoader)cl.parent()).addCloseTask(new Runnable(){

                @Override
                public void run() {
                    Runtime.getRuntime().removeShutdownHook(closeHookThread);
                }
            });
        }
        databases = closeableList;
        cachedProperties = hashMap;
        return new DevServicesDatasourceResultBuildItem(defaultResult, namedResults);
    }

    private DevServicesDatasourceResultBuildItem.DbResult startDevDb(String dbName, CurateOutcomeBuildItem curateOutcomeBuildItem, List<DefaultDataSourceDbKindBuildItem> installedDrivers, Map<String, DevServicesDatasourceProvider> devDBProviders, DataSourceBuildTimeConfig dataSourceBuildTimeConfig, Map<String, List<DevServicesDatasourceConfigurationHandlerBuildItem>> configurationHandlerBuildItems, Map<String, String> propertiesMap, List<Closeable> closeableList) {
        Optional defaultDbKind = DefaultDataSourceDbKindBuildItem.resolve((Optional)dataSourceBuildTimeConfig.dbKind, installedDrivers, (CurateOutcomeBuildItem)curateOutcomeBuildItem);
        if (!defaultDbKind.isPresent()) {
            log.warn((Object)("Unable to determine a database type for " + (dbName == null ? "default datasource" : dbName)));
            return null;
        }
        DevServicesDatasourceProvider devDbProvider = devDBProviders.get(defaultDbKind.get());
        List<DevServicesDatasourceConfigurationHandlerBuildItem> configHandlers = configurationHandlerBuildItems.get(defaultDbKind.get());
        if (devDbProvider == null || configHandlers == null) {
            log.warn((Object)("Unable to start devservices for " + (dbName == null ? "default datasource" : dbName) + " as this datasource type (" + (String)defaultDbKind.get() + ") does not support devservices"));
            return null;
        }
        Optional enabled = dataSourceBuildTimeConfig.devservices.enabled;
        if (enabled.isPresent()) {
            if (!((Boolean)enabled.get()).booleanValue()) {
                log.debug((Object)("Not starting devservices for " + (dbName == null ? "default datasource" : dbName) + " as it has been disabled in the config"));
                return null;
            }
        } else {
            for (DevServicesDatasourceConfigurationHandlerBuildItem i : configHandlers) {
                if (!i.getCheckConfiguredFunction().test(dbName)) continue;
                log.debug((Object)("Not starting devservices for " + (dbName == null ? "default datasource" : dbName) + " as it has explicit configuration"));
                return null;
            }
        }
        String prefix = "quarkus.datasource.";
        if (dbName != null) {
            prefix = prefix + dbName + ".";
        }
        DevServicesDatasourceProvider.RunningDevServicesDatasource datasource = devDbProvider.startDatabase(ConfigProvider.getConfig().getOptionalValue(prefix + "username", String.class), ConfigProvider.getConfig().getOptionalValue(prefix + "password", String.class), Optional.ofNullable(dbName), dataSourceBuildTimeConfig.devservices.imageName, dataSourceBuildTimeConfig.devservices.properties);
        closeableList.add(datasource.getCloseTask());
        HashMap<String, Object> devDebProperties = new HashMap<String, Object>();
        propertiesMap.put(prefix + "db-kind", dataSourceBuildTimeConfig.dbKind.orElse(null));
        for (DevServicesDatasourceConfigurationHandlerBuildItem devDbConfigurationHandlerBuildItem : configHandlers) {
            devDebProperties.putAll((Map)devDbConfigurationHandlerBuildItem.getConfigProviderFunction().apply(dbName, datasource));
        }
        devDebProperties.put(prefix + "db-kind", defaultDbKind.get());
        if (datasource.getUsername() != null) {
            devDebProperties.put(prefix + "username", datasource.getUsername());
        }
        if (datasource.getPassword() != null) {
            devDebProperties.put(prefix + "password", datasource.getPassword());
        }
        return new DevServicesDatasourceResultBuildItem.DbResult((String)defaultDbKind.get(), devDebProperties);
    }

    static {
        first = true;
    }
}

