/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.datasource.deployment.devservices;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.deployment.spi.DefaultDataSourceDbKindBuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceConfigurationHandlerBuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProviderBuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceResultBuildItem;
import io.quarkus.datasource.runtime.DataSourceBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.deployment.IsDockerWorking;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DevServicesNativeConfigResultBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class DevServicesDatasourceProcessor {
    private static final Logger log = Logger.getLogger(DevServicesDatasourceProcessor.class);
    static volatile List<Closeable> databases;
    static volatile Map<String, String> cachedProperties;
    static volatile List<RunTimeConfigurationDefaultBuildItem> databaseConfig;
    static volatile boolean first;
    private final IsDockerWorking isDockerWorking = new IsDockerWorking(true);

    @BuildStep(onlyIfNot={IsNormal.class})
    DevServicesDatasourceResultBuildItem launchDatabases(CurateOutcomeBuildItem curateOutcomeBuildItem, List<DefaultDataSourceDbKindBuildItem> installedDrivers, List<DevServicesDatasourceProviderBuildItem> devDBProviders, DataSourcesBuildTimeConfig dataSourceBuildTimeConfig, LaunchModeBuildItem launchMode, BuildProducer<RunTimeConfigurationDefaultBuildItem> runTimeConfigurationDefaultBuildItemBuildProducer, List<DevServicesDatasourceConfigurationHandlerBuildItem> configurationHandlerBuildItems, BuildProducer<DevServicesNativeConfigResultBuildItem> devServicesResultBuildItemBuildProducer, BuildProducer<ServiceStartBuildItem> serviceStartBuildItemBuildProducer) {
        if (databases != null) {
            boolean restartRequired = false;
            if (!restartRequired) {
                for (Map.Entry entry : cachedProperties.entrySet()) {
                    if (Objects.equals(entry.getValue(), ConfigProvider.getConfig().getOptionalValue((String)entry.getKey(), String.class).orElse(null))) continue;
                    restartRequired = true;
                    break;
                }
            }
            if (!restartRequired) {
                for (RunTimeConfigurationDefaultBuildItem runTimeConfigurationDefaultBuildItem : databaseConfig) {
                    runTimeConfigurationDefaultBuildItemBuildProducer.produce((BuildItem)runTimeConfigurationDefaultBuildItem);
                }
                return null;
            }
            for (Closeable closeable : databases) {
                try {
                    closeable.close();
                }
                catch (Throwable e) {
                    log.error((Object)"Failed to stop database", e);
                }
            }
            databases = null;
            cachedProperties = null;
            databaseConfig = null;
        }
        HashMap<String, DevServicesDatasourceResultBuildItem.DbResult> namedResults = new HashMap<String, DevServicesDatasourceResultBuildItem.DbResult>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<Closeable> closeableList = new ArrayList<Closeable>();
        Map<String, List<DevServicesDatasourceConfigurationHandlerBuildItem>> configHandlersByDbType = configurationHandlerBuildItems.stream().collect(Collectors.toMap(DevServicesDatasourceConfigurationHandlerBuildItem::getDbKind, Collections::singletonList, (configurationHandlerBuildItems1, configurationHandlerBuildItems2) -> {
            ArrayList ret = new ArrayList();
            ret.addAll(configurationHandlerBuildItems1);
            ret.addAll(configurationHandlerBuildItems2);
            return ret;
        }));
        Map<String, DevServicesDatasourceProvider> devDBProviderMap = devDBProviders.stream().collect(Collectors.toMap(DevServicesDatasourceProviderBuildItem::getDatabase, DevServicesDatasourceProviderBuildItem::getDevServicesProvider));
        DevServicesDatasourceResultBuildItem.DbResult defaultResult = this.startDevDb(null, curateOutcomeBuildItem, installedDrivers, !dataSourceBuildTimeConfig.namedDataSources.isEmpty(), devDBProviderMap, dataSourceBuildTimeConfig.defaultDataSource, configHandlersByDbType, hashMap, closeableList, launchMode.getLaunchMode());
        ArrayList<RunTimeConfigurationDefaultBuildItem> dbConfig = new ArrayList<RunTimeConfigurationDefaultBuildItem>();
        if (defaultResult != null) {
            for (Map.Entry entry : defaultResult.getConfigProperties().entrySet()) {
                dbConfig.add(new RunTimeConfigurationDefaultBuildItem((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        for (Map.Entry entry : dataSourceBuildTimeConfig.namedDataSources.entrySet()) {
            DevServicesDatasourceResultBuildItem.DbResult result = this.startDevDb((String)entry.getKey(), curateOutcomeBuildItem, installedDrivers, true, devDBProviderMap, (DataSourceBuildTimeConfig)entry.getValue(), configHandlersByDbType, hashMap, closeableList, launchMode.getLaunchMode());
            if (result == null) continue;
            namedResults.put((String)entry.getKey(), result);
            for (Map.Entry i : result.getConfigProperties().entrySet()) {
                dbConfig.add(new RunTimeConfigurationDefaultBuildItem((String)i.getKey(), (String)i.getValue()));
            }
        }
        for (RunTimeConfigurationDefaultBuildItem runTimeConfigurationDefaultBuildItem : dbConfig) {
            runTimeConfigurationDefaultBuildItemBuildProducer.produce((BuildItem)runTimeConfigurationDefaultBuildItem);
        }
        databaseConfig = dbConfig;
        if (first) {
            first = false;
            Runnable closeTask = new Runnable(){

                @Override
                public void run() {
                    if (databases != null) {
                        for (Closeable i : databases) {
                            try {
                                i.close();
                            }
                            catch (Throwable t) {
                                log.error((Object)"Failed to stop database", t);
                            }
                        }
                    }
                    first = true;
                    databases = null;
                    cachedProperties = null;
                }
            };
            QuarkusClassLoader quarkusClassLoader = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
            ((QuarkusClassLoader)quarkusClassLoader.parent()).addCloseTask(closeTask);
            final Thread closeHookThread = new Thread(closeTask, "Database shutdown thread");
            Runtime.getRuntime().addShutdownHook(closeHookThread);
            ((QuarkusClassLoader)quarkusClassLoader.parent()).addCloseTask(new Runnable(){

                @Override
                public void run() {
                    Runtime.getRuntime().removeShutdownHook(closeHookThread);
                }
            });
        }
        databases = closeableList;
        cachedProperties = hashMap;
        if (defaultResult != null) {
            for (Map.Entry entry : defaultResult.getConfigProperties().entrySet()) {
                devServicesResultBuildItemBuildProducer.produce((BuildItem)new DevServicesNativeConfigResultBuildItem((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        for (DevServicesDatasourceResultBuildItem.DbResult dbResult : namedResults.values()) {
            for (Map.Entry entry : dbResult.getConfigProperties().entrySet()) {
                devServicesResultBuildItemBuildProducer.produce((BuildItem)new DevServicesNativeConfigResultBuildItem((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        return new DevServicesDatasourceResultBuildItem(defaultResult, namedResults);
    }

    private DevServicesDatasourceResultBuildItem.DbResult startDevDb(String dbName, CurateOutcomeBuildItem curateOutcomeBuildItem, List<DefaultDataSourceDbKindBuildItem> installedDrivers, boolean hasNamedDatasources, Map<String, DevServicesDatasourceProvider> devDBProviders, DataSourceBuildTimeConfig dataSourceBuildTimeConfig, Map<String, List<DevServicesDatasourceConfigurationHandlerBuildItem>> configurationHandlerBuildItems, Map<String, String> propertiesMap, List<Closeable> closeableList, LaunchMode launchMode) {
        Optional enabled = dataSourceBuildTimeConfig.devservices.enabled;
        if (enabled.isPresent() && !((Boolean)enabled.get()).booleanValue()) {
            log.debug((Object)("Not starting devservices for " + (dbName == null ? "default datasource" : dbName) + " as it has been disabled in the config"));
            return null;
        }
        Optional defaultDbKind = DefaultDataSourceDbKindBuildItem.resolve((Optional)dataSourceBuildTimeConfig.dbKind, installedDrivers, (dbName != null || enabled.orElse(!hasNamedDatasources) != false ? 1 : 0) != 0, (CurateOutcomeBuildItem)curateOutcomeBuildItem);
        if (!defaultDbKind.isPresent()) {
            log.warn((Object)("Unable to determine a database type for " + (dbName == null ? "default datasource" : dbName)));
            return null;
        }
        DevServicesDatasourceProvider devDbProvider = devDBProviders.get(defaultDbKind.get());
        List<DevServicesDatasourceConfigurationHandlerBuildItem> configHandlers = configurationHandlerBuildItems.get(defaultDbKind.get());
        if (devDbProvider == null || configHandlers == null) {
            log.warn((Object)("Unable to start devservices for " + (dbName == null ? "default datasource" : dbName) + " as this datasource type (" + (String)defaultDbKind.get() + ") does not support devservices"));
            return null;
        }
        if (devDbProvider.isDockerRequired() && !this.isDockerWorking.getAsBoolean()) {
            String message = "Please configure the datasource URL for " + (String)(dbName == null ? "the default datasource" : " datasource '" + dbName + "'") + " or ensure the Docker daemon is up and running.";
            if (launchMode == LaunchMode.TEST) {
                throw new IllegalStateException(message);
            }
            log.warn((Object)message);
            return null;
        }
        if (!enabled.isPresent()) {
            for (DevServicesDatasourceConfigurationHandlerBuildItem i : configHandlers) {
                if (!i.getCheckConfiguredFunction().test(dbName)) continue;
                log.debug((Object)("Not starting devservices for " + (dbName == null ? "default datasource" : dbName) + " as it has explicit configuration"));
                return null;
            }
        }
        Object prefix = "quarkus.datasource.";
        if (dbName != null) {
            prefix = (String)prefix + dbName + ".";
        }
        DevServicesDatasourceProvider.RunningDevServicesDatasource datasource = devDbProvider.startDatabase(ConfigProvider.getConfig().getOptionalValue((String)prefix + "username", String.class), ConfigProvider.getConfig().getOptionalValue((String)prefix + "password", String.class), Optional.ofNullable(dbName), dataSourceBuildTimeConfig.devservices.imageName, dataSourceBuildTimeConfig.devservices.properties, dataSourceBuildTimeConfig.devservices.port, launchMode);
        closeableList.add(datasource.getCloseTask());
        HashMap<CallSite, String> devDebProperties = new HashMap<CallSite, String>();
        propertiesMap.put((String)prefix + "db-kind", dataSourceBuildTimeConfig.dbKind.orElse(null));
        for (DevServicesDatasourceConfigurationHandlerBuildItem devDbConfigurationHandlerBuildItem : configHandlers) {
            devDebProperties.putAll((Map)devDbConfigurationHandlerBuildItem.getConfigProviderFunction().apply(dbName, datasource));
        }
        devDebProperties.put((CallSite)((Object)((String)prefix + "db-kind")), (String)defaultDbKind.get());
        if (datasource.getUsername() != null) {
            devDebProperties.put((CallSite)((Object)((String)prefix + "username")), datasource.getUsername());
        }
        if (datasource.getPassword() != null) {
            devDebProperties.put((CallSite)((Object)((String)prefix + "password")), datasource.getPassword());
        }
        return new DevServicesDatasourceResultBuildItem.DbResult((String)defaultDbKind.get(), devDebProperties);
    }

    static {
        first = true;
    }
}

