/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.datasource.deployment.devservices;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.deployment.spi.DefaultDataSourceDbKindBuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceConfigurationHandlerBuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceContainerConfig;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProviderBuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceResultBuildItem;
import io.quarkus.datasource.runtime.DataSourceBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
public class DevServicesDatasourceProcessor {
    private static final Logger log = Logger.getLogger(DevServicesDatasourceProcessor.class);
    private static final int DOCKER_PS_ID_LENGTH = 12;
    private static final Set<String> EXCLUDED_PROPERTIES = Set.of("quarkus.datasource.devservices.enabled");
    static volatile List<DevServicesResultBuildItem.RunningDevService> databases;
    static volatile Map<String, String> cachedProperties;
    static volatile boolean first;

    @BuildStep
    DevServicesDatasourceResultBuildItem launchDatabases(CurateOutcomeBuildItem curateOutcomeBuildItem, DockerStatusBuildItem dockerStatusBuildItem, List<DefaultDataSourceDbKindBuildItem> installedDrivers, List<DevServicesDatasourceProviderBuildItem> devDBProviders, DataSourcesBuildTimeConfig dataSourceBuildTimeConfig, LaunchModeBuildItem launchMode, List<DevServicesDatasourceConfigurationHandlerBuildItem> configurationHandlerBuildItems, BuildProducer<DevServicesResultBuildItem> devServicesResultBuildItemBuildProducer, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig globalDevServicesConfig) {
        if (databases != null) {
            boolean restartRequired = false;
            if (!restartRequired) {
                for (Map.Entry<String, String> entry : cachedProperties.entrySet()) {
                    if (Objects.equals(entry.getValue(), this.trim(ConfigProvider.getConfig().getOptionalValue(entry.getKey(), String.class).orElse(null)))) continue;
                    restartRequired = true;
                    break;
                }
            }
            if (!restartRequired) {
                for (String string : ConfigProvider.getConfig().getPropertyNames()) {
                    if (!string.startsWith("quarkus.datasource.") || !string.contains(".devservices.") || cachedProperties.containsKey(string) || EXCLUDED_PROPERTIES.contains(string)) continue;
                    restartRequired = true;
                    break;
                }
            }
            if (!restartRequired) {
                for (DevServicesResultBuildItem.RunningDevService runningDevService : databases) {
                    devServicesResultBuildItemBuildProducer.produce((BuildItem)runningDevService.toBuildItem());
                }
                return null;
            }
            for (Closeable closeable : databases) {
                try {
                    closeable.close();
                }
                catch (Throwable e) {
                    log.error((Object)"Failed to stop database", e);
                }
            }
            databases = null;
            cachedProperties = null;
        }
        HashMap<String, DevServicesDatasourceResultBuildItem.DbResult> namedResults = new HashMap<String, DevServicesDatasourceResultBuildItem.DbResult>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<DevServicesResultBuildItem.RunningDevService> runningDevServices = new ArrayList<DevServicesResultBuildItem.RunningDevService>();
        Map<String, List<DevServicesDatasourceConfigurationHandlerBuildItem>> configHandlersByDbType = configurationHandlerBuildItems.stream().collect(Collectors.toMap(DevServicesDatasourceConfigurationHandlerBuildItem::getDbKind, Collections::singletonList, (configurationHandlerBuildItems1, configurationHandlerBuildItems2) -> {
            ArrayList ret = new ArrayList();
            ret.addAll(configurationHandlerBuildItems1);
            ret.addAll(configurationHandlerBuildItems2);
            return ret;
        }));
        Map<String, DevServicesDatasourceProvider> devDBProviderMap = devDBProviders.stream().collect(Collectors.toMap(DevServicesDatasourceProviderBuildItem::getDatabase, DevServicesDatasourceProviderBuildItem::getDevServicesProvider));
        DevServicesResultBuildItem.RunningDevService defaultDevService = this.startDevDb(null, curateOutcomeBuildItem, installedDrivers, !dataSourceBuildTimeConfig.namedDataSources.isEmpty(), devDBProviderMap, dataSourceBuildTimeConfig.defaultDataSource, configHandlersByDbType, hashMap, dockerStatusBuildItem, launchMode.getLaunchMode(), consoleInstalledBuildItem, loggingSetupBuildItem, globalDevServicesConfig);
        if (defaultDevService != null) {
            runningDevServices.add(defaultDevService);
        }
        DevServicesDatasourceResultBuildItem.DbResult defaultResult = this.toDbResult(defaultDevService);
        for (Map.Entry entry : dataSourceBuildTimeConfig.namedDataSources.entrySet()) {
            DevServicesResultBuildItem.RunningDevService namedDevService = this.startDevDb((String)entry.getKey(), curateOutcomeBuildItem, installedDrivers, true, devDBProviderMap, (DataSourceBuildTimeConfig)entry.getValue(), configHandlersByDbType, hashMap, dockerStatusBuildItem, launchMode.getLaunchMode(), consoleInstalledBuildItem, loggingSetupBuildItem, globalDevServicesConfig);
            if (namedDevService == null) continue;
            runningDevServices.add(namedDevService);
            namedResults.put((String)entry.getKey(), this.toDbResult(namedDevService));
        }
        if (first) {
            first = false;
            Runnable closeTask = new Runnable(){

                @Override
                public void run() {
                    if (databases != null) {
                        for (Closeable closeable : databases) {
                            try {
                                closeable.close();
                            }
                            catch (Throwable t) {
                                log.error((Object)"Failed to stop database", t);
                            }
                        }
                    }
                    first = true;
                    databases = null;
                    cachedProperties = null;
                }
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
        databases = runningDevServices;
        cachedProperties = hashMap;
        for (DevServicesResultBuildItem.RunningDevService database : databases) {
            devServicesResultBuildItemBuildProducer.produce((BuildItem)database.toBuildItem());
        }
        return new DevServicesDatasourceResultBuildItem(defaultResult, namedResults);
    }

    private String trim(String optional) {
        if (optional == null) {
            return null;
        }
        return optional.trim();
    }

    private DevServicesResultBuildItem.RunningDevService startDevDb(String dbName, CurateOutcomeBuildItem curateOutcomeBuildItem, List<DefaultDataSourceDbKindBuildItem> installedDrivers, boolean hasNamedDatasources, Map<String, DevServicesDatasourceProvider> devDBProviders, DataSourceBuildTimeConfig dataSourceBuildTimeConfig, Map<String, List<DevServicesDatasourceConfigurationHandlerBuildItem>> configurationHandlerBuildItems, Map<String, String> propertiesMap, DockerStatusBuildItem dockerStatusBuildItem, LaunchMode launchMode, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig globalDevServicesConfig) {
        Object prettyName;
        boolean explicitlyDisabled;
        boolean bl = explicitlyDisabled = dataSourceBuildTimeConfig.devservices.enabled.orElse(true) == false;
        if (explicitlyDisabled) {
            log.debug((Object)("Not starting Dev Services for " + (dbName == null ? "default datasource" : dbName) + " as it has been disabled in the configuration"));
            return null;
        }
        Boolean enabled = dataSourceBuildTimeConfig.devservices.enabled.orElse(!hasNamedDatasources);
        Optional defaultDbKind = DefaultDataSourceDbKindBuildItem.resolve((Optional)dataSourceBuildTimeConfig.dbKind, installedDrivers, (dbName != null || enabled != false ? 1 : 0) != 0, (CurateOutcomeBuildItem)curateOutcomeBuildItem);
        if (!defaultDbKind.isPresent()) {
            log.warn((Object)("Unable to determine a database type for " + (dbName == null ? "default datasource" : dbName)));
            return null;
        }
        DevServicesDatasourceProvider devDbProvider = devDBProviders.get(defaultDbKind.get());
        List<DevServicesDatasourceConfigurationHandlerBuildItem> configHandlers = configurationHandlerBuildItems.get(defaultDbKind.get());
        if (devDbProvider == null || configHandlers == null) {
            log.warn((Object)("Unable to start Dev Services for " + (dbName == null ? "default datasource" : dbName) + " as this datasource type (" + (String)defaultDbKind.get() + ") does not support Dev Services"));
            return null;
        }
        if (dataSourceBuildTimeConfig.devservices.enabled.isEmpty()) {
            for (DevServicesDatasourceConfigurationHandlerBuildItem i : configHandlers) {
                if (!i.getCheckConfiguredFunction().test(dbName)) continue;
                log.debug((Object)("Not starting Dev Services for " + (dbName == null ? "default datasource" : dbName) + " as it has explicit configuration"));
                return null;
            }
        }
        Object object = prettyName = dbName == null ? "the default datasource" : " datasource '" + dbName + "'";
        if (devDbProvider.isDockerRequired() && !dockerStatusBuildItem.isDockerAvailable()) {
            String message = "Please configure the datasource URL for " + (String)prettyName + " or ensure the Docker daemon is up and running.";
            if (launchMode == LaunchMode.TEST) {
                throw new IllegalStateException(message);
            }
            log.warn((Object)message);
            return null;
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode == LaunchMode.TEST ? "(test) " : "") + "Database for " + (String)prettyName + " (" + (String)defaultDbKind.get() + ") starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            DevServicesDatasourceContainerConfig containerConfig = new DevServicesDatasourceContainerConfig(dataSourceBuildTimeConfig.devservices.imageName, dataSourceBuildTimeConfig.devservices.containerProperties, dataSourceBuildTimeConfig.devservices.properties, dataSourceBuildTimeConfig.devservices.port, dataSourceBuildTimeConfig.devservices.command, dataSourceBuildTimeConfig.devservices.dbName, dataSourceBuildTimeConfig.devservices.username, dataSourceBuildTimeConfig.devservices.password, dataSourceBuildTimeConfig.devservices.initScriptPath, dataSourceBuildTimeConfig.devservices.volumes);
            DevServicesDatasourceProvider.RunningDevServicesDatasource datasource = devDbProvider.startDatabase(ConfigUtils.getFirstOptionalValue((List)DataSourceUtil.dataSourcePropertyKeys((String)dbName, (String)"username"), String.class), ConfigUtils.getFirstOptionalValue((List)DataSourceUtil.dataSourcePropertyKeys((String)dbName, (String)"password"), String.class), Optional.ofNullable(dbName), containerConfig, launchMode, globalDevServicesConfig.timeout);
            for (Object key : DataSourceUtil.dataSourcePropertyKeys((String)dbName, (String)"db-kind")) {
                propertiesMap.put((String)key, dataSourceBuildTimeConfig.dbKind.orElse(null));
            }
            String devServicesPrefix = "devservices.";
            if (dataSourceBuildTimeConfig.devservices.command.isPresent()) {
                this.setDataSourceProperties(propertiesMap, dbName, devServicesPrefix + "command", (String)dataSourceBuildTimeConfig.devservices.command.get());
            }
            if (dataSourceBuildTimeConfig.devservices.imageName.isPresent()) {
                this.setDataSourceProperties(propertiesMap, dbName, devServicesPrefix + "image-name", (String)dataSourceBuildTimeConfig.devservices.imageName.get());
            }
            if (dataSourceBuildTimeConfig.devservices.port.isPresent()) {
                this.setDataSourceProperties(propertiesMap, dbName, devServicesPrefix + "port", Integer.toString(dataSourceBuildTimeConfig.devservices.port.getAsInt()));
            }
            if (!dataSourceBuildTimeConfig.devservices.properties.isEmpty()) {
                for (Map.Entry entry : dataSourceBuildTimeConfig.devservices.properties.entrySet()) {
                    this.setDataSourceProperties(propertiesMap, dbName, devServicesPrefix + "properties." + (String)entry.getKey(), (String)entry.getValue());
                }
            }
            HashMap<String, String> devDebProperties = new HashMap<String, String>();
            for (DevServicesDatasourceConfigurationHandlerBuildItem devDbConfigurationHandlerBuildItem : configHandlers) {
                devDebProperties.putAll((Map)devDbConfigurationHandlerBuildItem.getConfigProviderFunction().apply(dbName, datasource));
            }
            this.setDataSourceProperties(devDebProperties, dbName, "db-kind", (String)defaultDbKind.get());
            if (datasource.getUsername() != null) {
                this.setDataSourceProperties(devDebProperties, dbName, "username", datasource.getUsername());
            }
            if (datasource.getPassword() != null) {
                this.setDataSourceProperties(devDebProperties, dbName, "password", datasource.getPassword());
            }
            compressor.close();
            if (datasource.getId() == null) {
                log.infof("Dev Services for %s (%s) started", prettyName, defaultDbKind.get());
            } else {
                log.infof("Dev Services for %s (%s) started - container ID is %s", prettyName, defaultDbKind.get(), (Object)(datasource.getId().length() > 12 ? datasource.getId().substring(0, 12) : datasource.getId()));
            }
            List list = DataSourceUtil.dataSourcePropertyKeys((String)dbName, (String)"devservices.");
            for (String name : ConfigProvider.getConfig().getPropertyNames()) {
                for (String prefix : list) {
                    if (!name.startsWith(prefix)) continue;
                    devDebProperties.put(name, (String)ConfigProvider.getConfig().getValue(name, String.class));
                }
            }
            return new DevServicesResultBuildItem.RunningDevService((String)defaultDbKind.get(), datasource.getId(), datasource.getCloseTask(), devDebProperties);
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
    }

    private void setDataSourceProperties(Map<String, String> propertiesMap, String dbName, String propertyKeyRadical, String value) {
        for (String key : DataSourceUtil.dataSourcePropertyKeys((String)dbName, (String)propertyKeyRadical)) {
            propertiesMap.put(key, value);
        }
    }

    private DevServicesDatasourceResultBuildItem.DbResult toDbResult(DevServicesResultBuildItem.RunningDevService devService) {
        if (devService == null) {
            return null;
        }
        return new DevServicesDatasourceResultBuildItem.DbResult(devService.getName(), devService.getConfig());
    }

    static {
        first = true;
    }
}

