/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.datasource.deployment.devservices;

import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.datasource.runtime.DatabaseRecorder;
import io.quarkus.datasource.runtime.DatasourceJsonRpcService;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleTemplateInfoBuildItem;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import java.util.ArrayList;
import java.util.Collections;

public class DevUIDatasourceProcessor {
    @BuildStep
    public DevConsoleTemplateInfoBuildItem devConsoleInfo(DataSourcesBuildTimeConfig dataSourceBuildTimeConfig) {
        ArrayList<String> names = new ArrayList<String>();
        names.add("<default>");
        names.addAll(dataSourceBuildTimeConfig.namedDataSources.keySet());
        Collections.sort(names);
        return new DevConsoleTemplateInfoBuildItem("dbs", names);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.STATIC_INIT, optional=true)
    DevConsoleRouteBuildItem devConsoleCleanDatabaseHandler(DatabaseRecorder recorder) {
        return new DevConsoleRouteBuildItem("reset", "POST", recorder.devConsoleResetDatabaseHandler());
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    CardPageBuildItem create(DataSourcesBuildTimeConfig dataSourceBuildTimeConfig) {
        CardPageBuildItem card = new CardPageBuildItem();
        ArrayList<String> names = new ArrayList<String>();
        names.add("<default>");
        names.addAll(dataSourceBuildTimeConfig.namedDataSources.keySet());
        Collections.sort(names);
        card.addBuildTimeData("datasources", names);
        card.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Reset")).componentLink("qwc-datasources-reset.js").icon("font-awesome-solid:broom"));
        return card;
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    JsonRPCProvidersBuildItem registerJsonRpcBackend() {
        return new JsonRPCProvidersBuildItem(DatasourceJsonRpcService.class);
    }
}

