/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.datasource.runtime;

import io.quarkus.datasource.runtime.DataSourceBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesExcludedFromHealthChecks;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Recorder
public class DataSourcesExcludedFromHealthChecksRecorder {
    public RuntimeValue<DataSourcesExcludedFromHealthChecks> configureDataSourcesExcludedFromHealthChecks(DataSourcesBuildTimeConfig config) {
        Stream.Builder<String> builder = Stream.builder();
        if (config.defaultDataSource.healthExclude) {
            builder.add("<default>");
        }
        for (Map.Entry<String, DataSourceBuildTimeConfig> dataSource : config.namedDataSources.entrySet()) {
            if (!dataSource.getValue().healthExclude) continue;
            builder.add(dataSource.getKey());
        }
        Set<String> excludedNames = builder.build().collect(Collectors.toUnmodifiableSet());
        return new RuntimeValue((Object)new DataSourcesExcludedFromHealthChecks(excludedNames));
    }
}

