/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.datasource.runtime;

import io.quarkus.datasource.runtime.DataSourceBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesHealthSupport;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Recorder
public class DataSourcesHealthSupportRecorder {
    public RuntimeValue<DataSourcesHealthSupport> configureDataSourcesHealthSupport(DataSourcesBuildTimeConfig config) {
        Stream.Builder<String> configured = Stream.builder();
        Stream.Builder<String> excluded = Stream.builder();
        for (Map.Entry<String, DataSourceBuildTimeConfig> dataSource : config.dataSources().entrySet()) {
            if (dataSource.getValue().dbKind().isPresent()) {
                configured.add(dataSource.getKey());
            }
            if (!dataSource.getValue().healthExclude()) continue;
            excluded.add(dataSource.getKey());
        }
        Set<String> names = configured.build().collect(Collectors.toUnmodifiableSet());
        Set<String> excludedNames = excluded.build().collect(Collectors.toUnmodifiableSet());
        return new RuntimeValue((Object)new DataSourcesHealthSupport(names, excludedNames));
    }
}

