/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev;

import io.quarkus.dev.CompilationProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class ClassLoaderCompiler {
    public static final String DEV_MODE_CLASS_PATH = "META-INF/dev-mode-class-path.txt";
    private final List<CompilationProvider> compilationProviders;
    private final CompilationProvider.Context compilationContext;
    private final Set<String> allHandledExtensions;

    public ClassLoaderCompiler(ClassLoader classLoader, File outputDirectory, List<CompilationProvider> compilationProviders) throws IOException {
        this.compilationProviders = compilationProviders;
        ArrayList<URL> urls = new ArrayList<URL>();
        for (ClassLoader c = classLoader; c != null; c = c.getParent()) {
            if (!(c instanceof URLClassLoader)) continue;
            urls.addAll(Arrays.asList(((URLClassLoader)c).getURLs()));
        }
        try (InputStream devModeCp = classLoader.getResourceAsStream(DEV_MODE_CLASS_PATH);){
            BufferedReader r = new BufferedReader(new InputStreamReader(devModeCp, StandardCharsets.UTF_8));
            String cp = r.readLine();
            for (String i : cp.split(" ")) {
                urls.add(new URI(i).toURL());
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HashSet<String> parsedFiles = new HashSet<String>();
        ArrayDeque<String> toParse = new ArrayDeque<String>();
        for (URL url : urls) {
            toParse.add(new File(url.getPath()).getAbsolutePath());
        }
        HashSet<File> classPathElements = new HashSet<File>();
        classPathElements.add(outputDirectory);
        while (!toParse.isEmpty()) {
            String s = (String)toParse.poll();
            if (parsedFiles.contains(s)) continue;
            parsedFiles.add(s);
            File file = new File(s);
            if (!file.exists() || !file.getName().endsWith(".jar")) continue;
            classPathElements.add(file);
            if (file.isDirectory() || !file.getName().endsWith(".jar")) continue;
            try {
                JarFile jar = new JarFile(file);
                Throwable throwable = null;
                try {
                    Object classPath;
                    Manifest mf = jar.getManifest();
                    if (mf == null || mf.getMainAttributes() == null || (classPath = mf.getMainAttributes().get(Attributes.Name.CLASS_PATH)) == null) continue;
                    for (String i : classPath.toString().split(" ")) {
                        File f;
                        try {
                            URL u = new URL(i);
                            f = new File(u.getPath());
                        }
                        catch (MalformedURLException e) {
                            f = new File(file.getParentFile(), i);
                        }
                        if (!f.exists()) continue;
                        toParse.add(f.getAbsolutePath());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jar == null) continue;
                    if (throwable != null) {
                        try {
                            jar.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jar.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to open class path file " + file, e);
            }
        }
        this.compilationContext = new CompilationProvider.Context(classPathElements, outputDirectory);
        this.allHandledExtensions = new HashSet<String>();
        for (CompilationProvider compilationProvider : compilationProviders) {
            this.allHandledExtensions.add(compilationProvider.handledExtension());
        }
    }

    public Set<String> allHandledExtensions() {
        return this.allHandledExtensions;
    }

    public void compile(Map<String, Set<File>> extensionToChangedFiles) {
        block0: for (String extension : extensionToChangedFiles.keySet()) {
            for (CompilationProvider compilationProvider : this.compilationProviders) {
                if (!extension.equals(compilationProvider.handledExtension())) continue;
                compilationProvider.compile(extensionToChangedFiles.get(extension), this.compilationContext);
                continue block0;
            }
        }
    }
}

