/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev;

import io.quarkus.dev.RuntimeCompilationSetup;
import io.quarkus.dev.RuntimeUpdatesProcessor;
import io.quarkus.runner.RuntimeRunner;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.Timing;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

public class DevModeMain {
    private static final Logger log = Logger.getLogger(DevModeMain.class);
    private static volatile ClassLoader currentAppClassLoader;
    private static volatile URLClassLoader runtimeCl;
    private static File classesRoot;
    private static File wiringDir;
    private static File cacheDir;
    private static Closeable closeable;
    static volatile Throwable deploymentProblem;
    static RuntimeUpdatesProcessor runtimeUpdatesProcessor;

    public static void main(String ... args) throws Exception {
        Timing.staticInitStarted();
        classesRoot = new File(args[0]);
        wiringDir = new File(args[1]);
        cacheDir = new File(args[2]);
        File config = new File(classesRoot, "META-INF/microprofile-config.properties");
        if (config.exists()) {
            try {
                Config built = SmallRyeConfigProviderResolver.instance().getBuilder().addDefaultSources().addDiscoveredConverters().addDiscoveredSources().withSources(new ConfigSource[]{new PropertiesConfigSource(config.toURL())}).build();
                SmallRyeConfigProviderResolver.instance().registerConfig(built, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if ((runtimeUpdatesProcessor = RuntimeCompilationSetup.setup()) != null) {
            runtimeUpdatesProcessor.scanForChangedClasses();
        }
        DevModeMain.doStart();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<DevModeMain> clazz = DevModeMain.class;
                synchronized (DevModeMain.class) {
                    if (closeable != null) {
                        try {
                            closeable.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (runtimeCl != null) {
                        try {
                            runtimeCl.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        }, "Quarkus Shutdown Thread"));
    }

    private static synchronized void doStart() {
        try {
            runtimeCl = new URLClassLoader(new URL[]{classesRoot.toURL()}, ClassLoader.getSystemClassLoader());
            currentAppClassLoader = runtimeCl;
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(runtimeCl);
                RuntimeRunner runner = RuntimeRunner.builder().setLaunchMode(LaunchMode.DEVELOPMENT).setClassLoader((ClassLoader)runtimeCl).setTarget(classesRoot.toPath()).setFrameworkClassesPath(wiringDir.toPath()).setTransformerCache(cacheDir.toPath()).build();
                runner.run();
                closeable = runner;
                deploymentProblem = null;
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        catch (Throwable t) {
            deploymentProblem = t;
            log.error((Object)"Failed to start quarkus", t);
        }
    }

    public static synchronized void restartApp() {
        if (closeable != null) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(runtimeCl);
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        SmallRyeConfigProviderResolver.instance().releaseConfig(SmallRyeConfigProviderResolver.instance().getConfig());
        closeable = null;
        Timing.restart();
        DevModeMain.doStart();
    }

    public static ClassLoader getCurrentAppClassLoader() {
        return currentAppClassLoader;
    }
}

