/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev;

import io.quarkus.deployment.devmode.HotReplacementContext;
import io.quarkus.dev.ClassLoaderCompiler;
import io.quarkus.dev.CopyUtils;
import io.quarkus.dev.DevModeMain;
import io.quarkus.runtime.Timing;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class RuntimeUpdatesProcessor
implements HotReplacementContext {
    private final Path classesDir;
    private final Path sourcesDir;
    private final Path resourcesDir;
    private final ClassLoaderCompiler compiler;
    private volatile long lastChange = System.currentTimeMillis();
    private volatile Set<String> configFilePaths = Collections.emptySet();
    private final Map<String, Long> configFileTimestamps = new ConcurrentHashMap<String, Long>();
    private static final Logger log = Logger.getLogger((String)RuntimeUpdatesProcessor.class.getPackage().getName());

    public RuntimeUpdatesProcessor(Path classesDir, Path sourcesDir, Path resourcesDir, ClassLoaderCompiler compiler) {
        this.classesDir = classesDir;
        this.sourcesDir = sourcesDir;
        this.resourcesDir = resourcesDir;
        this.compiler = compiler;
    }

    public Path getClassesDir() {
        return this.classesDir;
    }

    public Path getSourcesDir() {
        return this.sourcesDir;
    }

    public Path getResourcesDir() {
        return this.resourcesDir;
    }

    public Throwable getDeploymentProblem() {
        return DevModeMain.deploymentProblem;
    }

    public void doScan() throws IOException {
        long startNanoseconds = System.nanoTime();
        ConcurrentMap<String, byte[]> changedClasses = this.scanForChangedClasses();
        if (changedClasses == null) {
            return;
        }
        DevModeMain.restartApp();
        log.infof("Hot replace total time: %ss ", (Object)Timing.convertToBigDecimalSeconds((long)(System.nanoTime() - startNanoseconds)));
    }

    ConcurrentMap<String, byte[]> scanForChangedClasses() throws IOException {
        ConcurrentMap<String, byte[]> changedClasses;
        Set changedSourceFiles;
        if (this.sourcesDir != null) {
            try (Stream<Path> sourcesStream = Files.walk(this.sourcesDir, new FileVisitOption[0]);){
                changedSourceFiles = ((Stream)sourcesStream.parallel()).filter(p -> this.matchingHandledExtension((Path)p).isPresent()).filter(p -> this.wasRecentlyModified((Path)p)).map(Path::toFile).collect(Collectors.toCollection(ConcurrentSkipListSet::new));
            }
        } else {
            changedSourceFiles = Collections.EMPTY_SET;
        }
        if (!changedSourceFiles.isEmpty()) {
            log.info((Object)("Changes source files detected, recompiling " + changedSourceFiles));
            try {
                this.compiler.compile(changedSourceFiles.stream().collect(Collectors.groupingBy(this::getFileExtension, Collectors.toSet())));
            }
            catch (Exception e) {
                DevModeMain.deploymentProblem = e;
                return null;
            }
        }
        try (Stream<Path> classesStream = Files.walk(this.classesDir, new FileVisitOption[0]);){
            changedClasses = ((Stream)classesStream.parallel()).filter(p -> p.toString().endsWith(".class")).filter(p -> this.wasRecentlyModified((Path)p)).collect(Collectors.toConcurrentMap(p -> this.pathToClassName((Path)p), p -> CopyUtils.readFileContentNoIOExceptions(p)));
        }
        if (changedClasses.isEmpty() && !this.checkForConfigFileChange()) {
            return null;
        }
        this.lastChange = System.currentTimeMillis();
        return changedClasses;
    }

    private Optional<String> matchingHandledExtension(Path p) {
        return this.compiler.allHandledExtensions().stream().filter(e -> p.toString().endsWith((String)e)).findFirst();
    }

    private String getFileExtension(File file) {
        String name = file.getName();
        int lastIndexOf = name.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return "";
        }
        return name.substring(lastIndexOf);
    }

    private boolean checkForConfigFileChange() {
        boolean ret = false;
        boolean doCopy = true;
        Path root = this.resourcesDir;
        if (root == null) {
            root = this.classesDir;
            doCopy = false;
        }
        for (String i : this.configFilePaths) {
            Path config = root.resolve(i);
            if (!Files.exists(config, new LinkOption[0])) continue;
            try {
                Long existing;
                long value = Files.getLastModifiedTime(config, new LinkOption[0]).toMillis();
                if (value <= (existing = this.configFileTimestamps.get(i))) continue;
                ret = true;
                if (!doCopy) continue;
                Path target = this.classesDir.resolve(i);
                byte[] data = CopyUtils.readFileContent(config);
                FileOutputStream out = new FileOutputStream(target.toFile());
                Throwable throwable = null;
                try {
                    out.write(data);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    out.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return ret;
    }

    private boolean wasRecentlyModified(Path p) {
        try {
            boolean recent;
            long sourceMod = Files.getLastModifiedTime(p, new LinkOption[0]).toMillis();
            boolean bl = recent = sourceMod > this.lastChange;
            if (recent) {
                return true;
            }
            Optional<String> matchingExtension = this.matchingHandledExtension(p);
            if (matchingExtension.isPresent()) {
                String pathName = this.sourcesDir.relativize(p).toString();
                String classFileName = pathName.substring(0, pathName.length() - matchingExtension.get().length()) + ".class";
                Path classFile = this.classesDir.resolve(classFileName);
                if (!Files.exists(classFile, new LinkOption[0])) {
                    return true;
                }
                return sourceMod > Files.getLastModifiedTime(classFile, new LinkOption[0]).toMillis();
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String pathToClassName(Path path) {
        String pathName = this.classesDir.relativize(path).toString();
        String className = pathName.substring(0, pathName.length() - 6).replace('/', '.');
        return className;
    }

    public RuntimeUpdatesProcessor setConfigFilePaths(Set<String> configFilePaths) {
        this.configFilePaths = configFilePaths;
        this.configFileTimestamps.clear();
        Path root = this.resourcesDir;
        if (root == null) {
            root = this.classesDir;
        }
        for (String i : configFilePaths) {
            Path config = root.resolve(i);
            if (Files.exists(config, new LinkOption[0])) {
                try {
                    this.configFileTimestamps.put(i, Files.getLastModifiedTime(config, new LinkOption[0]).toMillis());
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.configFileTimestamps.put(i, 0L);
        }
        return this;
    }

    static interface UpdateHandler {
        public void handle(Map<String, byte[]> var1);
    }
}

