/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev;

import io.quarkus.deployment.devmode.HotReplacementContext;
import io.quarkus.deployment.devmode.HotReplacementSetup;
import io.quarkus.dev.ClassLoaderCompiler;
import io.quarkus.dev.CompilationProvider;
import io.quarkus.dev.RuntimeUpdatesProcessor;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RuntimeCompilationSetup {
    public static final String PROP_RUNNER_CLASSES = "quarkus-internal.runner.classes";
    public static final String PROP_RUNNER_SOURCES = "quarkus-internal.runner.sources";
    public static final String PROP_RUNNER_RESOURCES = "quarkus-internal.runner.resources";
    private static Logger log = Logger.getLogger(RuntimeCompilationSetup.class.getName());

    public static RuntimeUpdatesProcessor setup() throws Exception {
        String classesDir = System.getProperty(PROP_RUNNER_CLASSES);
        String sourcesDir = System.getProperty(PROP_RUNNER_SOURCES);
        String resourcesDir = System.getProperty(PROP_RUNNER_RESOURCES);
        if (classesDir != null) {
            ServiceLoader<CompilationProvider> serviceLoader = ServiceLoader.load(CompilationProvider.class);
            ArrayList<CompilationProvider> compilationProviders = new ArrayList<CompilationProvider>();
            serviceLoader.iterator().forEachRemaining(compilationProviders::add);
            ClassLoaderCompiler compiler = null;
            try {
                compiler = new ClassLoaderCompiler(Thread.currentThread().getContextClassLoader(), new File(classesDir), compilationProviders);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to create compiler, runtime compilation will be unavailable", e);
                return null;
            }
            RuntimeUpdatesProcessor processor = new RuntimeUpdatesProcessor(Paths.get(classesDir, new String[0]), sourcesDir == null ? null : Paths.get(sourcesDir, new String[0]), resourcesDir == null ? null : Paths.get(resourcesDir, new String[0]), compiler);
            for (HotReplacementSetup service : ServiceLoader.load(HotReplacementSetup.class)) {
                service.setupHotDeployment((HotReplacementContext)processor);
            }
            return processor;
        }
        return null;
    }
}

