/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev;

import io.quarkus.deployment.devmode.HotReplacementContext;
import io.quarkus.dev.ClassLoaderCompiler;
import io.quarkus.dev.CopyUtils;
import io.quarkus.dev.DevModeMain;
import io.quarkus.runtime.Timing;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class RuntimeUpdatesProcessor
implements HotReplacementContext {
    private final Path classesDir;
    private final Path sourcesDir;
    private final Path resourcesDir;
    private final ClassLoaderCompiler compiler;
    private volatile long lastChange = System.currentTimeMillis();
    private volatile Set<String> configFilePaths = Collections.emptySet();
    private final Map<String, Long> configFileTimestamps = new ConcurrentHashMap<String, Long>();
    private static final Logger log = Logger.getLogger((String)RuntimeUpdatesProcessor.class.getPackage().getName());
    private final List<Runnable> preScanSteps = new CopyOnWriteArrayList<Runnable>();

    public RuntimeUpdatesProcessor(Path classesDir, Path sourcesDir, Path resourcesDir, ClassLoaderCompiler compiler) {
        this.classesDir = classesDir;
        this.sourcesDir = sourcesDir;
        this.resourcesDir = resourcesDir;
        this.compiler = compiler;
    }

    public Path getClassesDir() {
        return this.classesDir;
    }

    public Path getSourcesDir() {
        return this.sourcesDir;
    }

    public Path getResourcesDir() {
        return this.resourcesDir;
    }

    public Throwable getDeploymentProblem() {
        return DevModeMain.deploymentProblem;
    }

    public boolean doScan() throws IOException {
        long startNanoseconds = System.nanoTime();
        for (Runnable i : this.preScanSteps) {
            try {
                i.run();
            }
            catch (Throwable t) {
                log.error((Object)"Pre Scan step failed", t);
            }
        }
        boolean classChanged = this.checkForChangedClasses();
        boolean configFileChanged = this.checkForConfigFileChange();
        if (classChanged || configFileChanged) {
            DevModeMain.restartApp();
            log.infof("Hot replace total time: %ss ", (Object)Timing.convertToBigDecimalSeconds((long)(System.nanoTime() - startNanoseconds)));
            return true;
        }
        return false;
    }

    public void addPreScanStep(Runnable runnable) {
        this.preScanSteps.add(runnable);
    }

    boolean checkForChangedClasses() throws IOException {
        Set changedSourceFiles;
        Throwable throwable;
        if (this.sourcesDir != null) {
            throwable = null;
            try (Stream<Path> sourcesStream = Files.walk(this.sourcesDir, new FileVisitOption[0]);){
                changedSourceFiles = ((Stream)sourcesStream.parallel()).filter(p -> this.matchingHandledExtension((Path)p).isPresent()).filter(p -> this.wasRecentlyModified((Path)p)).map(Path::toFile).collect(Collectors.toCollection(ConcurrentSkipListSet::new));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        } else {
            changedSourceFiles = Collections.emptySet();
        }
        if (!changedSourceFiles.isEmpty()) {
            log.info((Object)("Changed source files detected, recompiling " + changedSourceFiles));
            try {
                this.compiler.compile(changedSourceFiles.stream().collect(Collectors.groupingBy(this::getFileExtension, Collectors.toSet())));
            }
            catch (Exception e) {
                DevModeMain.deploymentProblem = e;
                return false;
            }
        }
        throwable = null;
        try (Stream<Path> classesStream = Files.walk(this.classesDir, new FileVisitOption[0]);){
            if (((Stream)classesStream.parallel()).anyMatch(p -> p.toString().endsWith(".class") && this.wasRecentlyModified((Path)p))) {
                this.lastChange = System.currentTimeMillis();
                boolean bl = true;
                return bl;
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        return false;
    }

    private Optional<String> matchingHandledExtension(Path p) {
        return this.compiler.allHandledExtensions().stream().filter(e -> p.toString().endsWith((String)e)).findFirst();
    }

    private String getFileExtension(File file) {
        String name = file.getName();
        int lastIndexOf = name.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return "";
        }
        return name.substring(lastIndexOf);
    }

    private boolean checkForConfigFileChange() {
        Path root = this.resourcesDir;
        boolean doCopy = true;
        boolean configFilesHaveChanged = false;
        if (root == null) {
            root = this.classesDir;
            doCopy = false;
        }
        for (String configFilePath : this.configFilePaths) {
            Path config = root.resolve(configFilePath);
            if (Files.exists(config, new LinkOption[0])) {
                try {
                    Long existing;
                    long value = Files.getLastModifiedTime(config, new LinkOption[0]).toMillis();
                    if (value <= (existing = this.configFileTimestamps.get(configFilePath))) continue;
                    configFilesHaveChanged = true;
                    log.infof("Config file change detected: %s", (Object)config);
                    if (!doCopy) continue;
                    Path target = this.classesDir.resolve(configFilePath);
                    byte[] data = CopyUtils.readFileContent(config);
                    FileOutputStream out = new FileOutputStream(target.toFile());
                    Throwable throwable = null;
                    try {
                        out.write(data);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        out.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.configFileTimestamps.remove(configFilePath);
            Path target = this.classesDir.resolve(configFilePath);
            try {
                Files.deleteIfExists(target);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return configFilesHaveChanged;
    }

    private boolean wasRecentlyModified(Path p) {
        try {
            boolean recent;
            long sourceMod = Files.getLastModifiedTime(p, new LinkOption[0]).toMillis();
            boolean bl = recent = sourceMod > this.lastChange;
            if (recent) {
                return true;
            }
            Optional<String> matchingExtension = this.matchingHandledExtension(p);
            if (matchingExtension.isPresent()) {
                String pathName = this.sourcesDir.relativize(p).toString();
                String classFileName = pathName.substring(0, pathName.length() - matchingExtension.get().length()) + ".class";
                Path classFile = this.classesDir.resolve(classFileName);
                if (!Files.exists(classFile, new LinkOption[0])) {
                    return true;
                }
                return sourceMod > Files.getLastModifiedTime(classFile, new LinkOption[0]).toMillis();
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RuntimeUpdatesProcessor setConfigFilePaths(Set<String> configFilePaths) {
        this.configFilePaths = configFilePaths;
        this.configFileTimestamps.clear();
        Path root = this.resourcesDir;
        if (root == null) {
            root = this.classesDir;
        }
        for (String i : configFilePaths) {
            Path config = root.resolve(i);
            if (Files.exists(config, new LinkOption[0])) {
                try {
                    this.configFileTimestamps.put(i, Files.getLastModifiedTime(config, new LinkOption[0]).toMillis());
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.configFileTimestamps.put(i, 0L);
        }
        return this;
    }
}

