/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev;

import io.quarkus.dev.DevModeContext;
import io.quarkus.dev.RuntimeCompilationSetup;
import io.quarkus.dev.RuntimeUpdatesProcessor;
import io.quarkus.runner.RuntimeRunner;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.Timing;
import io.quarkus.runtime.logging.InitialConfigurator;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Handler;
import org.jboss.logging.Logger;

public class DevModeMain {
    public static final String DEV_MODE_CONTEXT = "META-INF/dev-mode-context.dat";
    private static final Logger log = Logger.getLogger(DevModeMain.class);
    private static volatile ClassLoader currentAppClassLoader;
    private static volatile URLClassLoader runtimeCl;
    private static File classesRoot;
    private static File wiringDir;
    private static File cacheDir;
    private static DevModeContext context;
    private static Closeable runner;
    static volatile Throwable deploymentProblem;
    static RuntimeUpdatesProcessor runtimeUpdatesProcessor;

    public static void main(String ... args) throws Exception {
        Timing.staticInitStarted();
        try (InputStream devModeCp = DevModeMain.class.getClassLoader().getResourceAsStream(DEV_MODE_CONTEXT);){
            context = (DevModeContext)new ObjectInputStream(new DataInputStream(devModeCp)).readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry<String, String> i : context.getSystemProperties().entrySet()) {
            if (System.getProperties().containsKey(i.getKey())) continue;
            System.setProperty(i.getKey(), i.getValue());
        }
        classesRoot = new File(args[0]);
        wiringDir = new File(args[1]);
        cacheDir = new File(args[2]);
        runtimeUpdatesProcessor = RuntimeCompilationSetup.setup(context);
        if (runtimeUpdatesProcessor != null) {
            runtimeUpdatesProcessor.checkForChangedClasses();
        }
        DevModeMain.doStart();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<DevModeMain> clazz = DevModeMain.class;
                synchronized (DevModeMain.class) {
                    if (runner != null) {
                        try {
                            runner.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (runtimeCl != null) {
                        try {
                            runtimeCl.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        }, "Quarkus Shutdown Thread"));
        LockSupport.park();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void doStart() {
        block6: {
            try {
                runtimeCl = new URLClassLoader(new URL[]{classesRoot.toURL()}, ClassLoader.getSystemClassLoader());
                currentAppClassLoader = runtimeCl;
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(runtimeCl);
                    RuntimeRunner.Builder builder = RuntimeRunner.builder().setLaunchMode(LaunchMode.DEVELOPMENT).setClassLoader((ClassLoader)runtimeCl).setTarget(classesRoot.toPath()).setFrameworkClassesPath(wiringDir.toPath()).setTransformerCache(cacheDir.toPath());
                    for (DevModeContext.ModuleInfo i : context.getModules()) {
                        if (i.getClassesPath() == null) continue;
                        builder.addAdditionalHotDeploymentPath(Paths.get(i.getClassesPath(), new String[0]));
                    }
                    RuntimeRunner runner = builder.build();
                    runner.run();
                    DevModeMain.runner = runner;
                    deploymentProblem = null;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
            catch (Throwable t) {
                deploymentProblem = t;
                log.error((Object)"Failed to start quarkus", t);
                if (InitialConfigurator.DELAYED_HANDLER.isActivated()) break block6;
                InitialConfigurator.DELAYED_HANDLER.setHandlers(new Handler[]{InitialConfigurator.createDefaultHandler()});
            }
        }
    }

    public static synchronized void restartApp() {
        if (runner != null) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(runtimeCl);
            try {
                runner.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        SmallRyeConfigProviderResolver.instance().releaseConfig(SmallRyeConfigProviderResolver.instance().getConfig());
        runner = null;
        Timing.restart();
        DevModeMain.doStart();
    }

    public static ClassLoader getCurrentAppClassLoader() {
        return currentAppClassLoader;
    }
}

