/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev;

import io.quarkus.deployment.devmode.HotReplacementContext;
import io.quarkus.deployment.devmode.HotReplacementSetup;
import io.quarkus.dev.ClassLoaderCompiler;
import io.quarkus.dev.CompilationProvider;
import io.quarkus.dev.DevModeContext;
import io.quarkus.dev.RuntimeUpdatesProcessor;
import java.util.ArrayList;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RuntimeCompilationSetup {
    private static Logger log = Logger.getLogger(RuntimeCompilationSetup.class.getName());

    public static RuntimeUpdatesProcessor setup(DevModeContext context) throws Exception {
        if (!context.getModules().isEmpty()) {
            ClassLoaderCompiler compiler;
            ServiceLoader<CompilationProvider> serviceLoader = ServiceLoader.load(CompilationProvider.class);
            ArrayList<CompilationProvider> compilationProviders = new ArrayList<CompilationProvider>();
            serviceLoader.iterator().forEachRemaining(compilationProviders::add);
            try {
                compiler = new ClassLoaderCompiler(Thread.currentThread().getContextClassLoader(), compilationProviders, context);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to create compiler, runtime compilation will be unavailable", e);
                return null;
            }
            RuntimeUpdatesProcessor processor = new RuntimeUpdatesProcessor(context, compiler);
            for (HotReplacementSetup service : ServiceLoader.load(HotReplacementSetup.class)) {
                service.setupHotDeployment((HotReplacementContext)processor);
            }
            return processor;
        }
        return null;
    }
}

