/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev;

import io.quarkus.dev.CompilationProvider;
import io.quarkus.dev.DevModeContext;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jboss.logging.Logger;

public class ClassLoaderCompiler {
    private static final Logger log = Logger.getLogger(ClassLoaderCompiler.class);
    private final List<CompilationProvider> compilationProviders;
    private final Map<String, CompilationProvider.Context> compilationContexts = new HashMap<String, CompilationProvider.Context>();
    private final Set<String> allHandledExtensions;

    public ClassLoaderCompiler(ClassLoader classLoader, List<CompilationProvider> compilationProviders, DevModeContext context) throws IOException {
        this.compilationProviders = compilationProviders;
        ArrayList<URL> urls = new ArrayList<URL>();
        for (ClassLoader c = classLoader; c != null; c = c.getParent()) {
            if (!(c instanceof URLClassLoader)) continue;
            urls.addAll(Arrays.asList(((URLClassLoader)c).getURLs()));
        }
        urls.addAll(context.getClassPath());
        HashSet<String> parsedFiles = new HashSet<String>();
        ArrayDeque<String> toParse = new ArrayDeque<String>();
        for (URL uRL : urls) {
            toParse.add(new File(URLDecoder.decode(uRL.getPath(), StandardCharsets.UTF_8.name())).getAbsolutePath());
        }
        HashSet<File> classPathElements = new HashSet<File>();
        for (DevModeContext.ModuleInfo i : context.getModules()) {
            if (i.getClassesPath() == null) continue;
            classPathElements.add(new File(i.getClassesPath()));
        }
        while (!toParse.isEmpty()) {
            String string = (String)toParse.poll();
            if (parsedFiles.contains(string)) continue;
            parsedFiles.add(string);
            File file = new File(string);
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                classPathElements.add(file);
                continue;
            }
            if (!file.getName().endsWith(".jar")) continue;
            classPathElements.add(file);
            if (file.isDirectory() || !file.getName().endsWith(".jar")) continue;
            try {
                JarFile jar = new JarFile(file);
                Throwable throwable = null;
                try {
                    Object classPath;
                    Manifest mf = jar.getManifest();
                    if (mf == null || mf.getMainAttributes() == null || (classPath = mf.getMainAttributes().get(Attributes.Name.CLASS_PATH)) == null) continue;
                    for (String i : classPath.toString().split(" ")) {
                        File f;
                        try {
                            URL u = new URL(i);
                            f = new File(u.getPath());
                        }
                        catch (MalformedURLException e) {
                            f = new File(file.getParentFile(), i);
                        }
                        if (!f.exists()) continue;
                        toParse.add(f.getAbsolutePath());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jar == null) continue;
                    if (throwable != null) {
                        try {
                            jar.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jar.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to open class path file " + file, e);
            }
        }
        for (DevModeContext.ModuleInfo i : context.getModules()) {
            if (i.getSourcePath() == null) continue;
            if (i.getClassesPath() == null) {
                log.warn((Object)("No classes directory found for module '" + i.getName() + "'. It is advised that this module be compiled before launching dev mode"));
                continue;
            }
            this.compilationContexts.put(i.getSourcePath(), new CompilationProvider.Context(classPathElements, new File(i.getClassesPath())));
        }
        this.allHandledExtensions = new HashSet<String>();
        for (CompilationProvider compilationProvider : compilationProviders) {
            this.allHandledExtensions.addAll(compilationProvider.handledExtensions());
        }
    }

    public Set<String> allHandledExtensions() {
        return this.allHandledExtensions;
    }

    public void compile(String sourceDir, Map<String, Set<File>> extensionToChangedFiles) {
        CompilationProvider.Context compilationContext = this.compilationContexts.get(sourceDir);
        block0: for (String extension : extensionToChangedFiles.keySet()) {
            for (CompilationProvider compilationProvider : this.compilationProviders) {
                if (!compilationProvider.handledExtensions().contains(extension)) continue;
                compilationProvider.compile(extensionToChangedFiles.get(extension), compilationContext);
                continue block0;
            }
        }
    }
}

