/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;

public final class CopyUtils {
    private CopyUtils() {
    }

    public static byte[] readFileContentNoIOExceptions(Path path) {
        try {
            return CopyUtils.readFileContent(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] readFileContent(Path path) throws IOException {
        File file = path.toFile();
        long fileLength = file.length();
        if (fileLength > Integer.MAX_VALUE) {
            throw new RuntimeException("Can't process class files larger than Integer.MAX_VALUE bytes");
        }
        int intLength = (int)fileLength;
        try (FileInputStream in = new FileInputStream(file);){
            int r;
            ByteArrayOutputStream out = new ByteArrayOutputStream(intLength);
            int reasonableBufferSize = Math.min(intLength, 2048);
            byte[] buf = new byte[reasonableBufferSize];
            while ((r = in.read(buf)) > 0) {
                out.write(buf, 0, r);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }
}

