/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev;

import io.quarkus.deployment.devmode.HotReplacementContext;
import io.quarkus.dev.ClassLoaderCompiler;
import io.quarkus.dev.CopyUtils;
import io.quarkus.dev.DevModeContext;
import io.quarkus.dev.DevModeMain;
import io.quarkus.runtime.Timing;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class RuntimeUpdatesProcessor
implements HotReplacementContext {
    private final DevModeContext context;
    private final ClassLoaderCompiler compiler;
    private volatile long lastChange = System.currentTimeMillis();
    private volatile Set<String> configFilePaths = Collections.emptySet();
    private final Map<Path, Long> configFileTimestamps = new ConcurrentHashMap<Path, Long>();
    private static final Logger log = Logger.getLogger((String)RuntimeUpdatesProcessor.class.getPackage().getName());
    private final List<Runnable> preScanSteps = new CopyOnWriteArrayList<Runnable>();

    public RuntimeUpdatesProcessor(DevModeContext context, ClassLoaderCompiler compiler) {
        this.context = context;
        this.compiler = compiler;
    }

    public Path getClassesDir() {
        Iterator<DevModeContext.ModuleInfo> iterator = this.context.getModules().iterator();
        if (iterator.hasNext()) {
            DevModeContext.ModuleInfo i = iterator.next();
            return Paths.get(i.getResourcePath(), new String[0]);
        }
        return null;
    }

    public Path getSourcesDir() {
        for (DevModeContext.ModuleInfo i : this.context.getModules()) {
            if (i.getSourcePath() == null) continue;
            return Paths.get(i.getSourcePath(), new String[0]);
        }
        return null;
    }

    public List<Path> getResourcesDir() {
        ArrayList<Path> ret = new ArrayList<Path>();
        for (DevModeContext.ModuleInfo i : this.context.getModules()) {
            if (i.getResourcePath() == null) continue;
            ret.add(Paths.get(i.getResourcePath(), new String[0]));
        }
        Collections.reverse(ret);
        return ret;
    }

    public Throwable getDeploymentProblem() {
        return DevModeMain.deploymentProblem;
    }

    public boolean doScan() throws IOException {
        long startNanoseconds = System.nanoTime();
        for (Runnable i : this.preScanSteps) {
            try {
                i.run();
            }
            catch (Throwable t) {
                log.error((Object)"Pre Scan step failed", t);
            }
        }
        boolean classChanged = this.checkForChangedClasses();
        boolean configFileChanged = this.checkForConfigFileChange();
        if (classChanged || configFileChanged) {
            DevModeMain.restartApp();
            log.infof("Hot replace total time: %ss ", (Object)Timing.convertToBigDecimalSeconds((long)(System.nanoTime() - startNanoseconds)));
            return true;
        }
        return false;
    }

    public void addPreScanStep(Runnable runnable) {
        this.preScanSteps.add(runnable);
    }

    boolean checkForChangedClasses() throws IOException {
        for (DevModeContext.ModuleInfo i : this.context.getModules()) {
            Set changedSourceFiles;
            if (i.getSourcePath() == null) continue;
            try (Stream<Path> sourcesStream = Files.walk(Paths.get(i.getSourcePath(), new String[0]), new FileVisitOption[0]);){
                changedSourceFiles = ((Stream)sourcesStream.parallel()).filter(p -> this.matchingHandledExtension((Path)p).isPresent()).filter(p -> this.wasRecentlyModified((Path)p, i)).map(Path::toFile).collect(Collectors.toCollection(ConcurrentSkipListSet::new));
            }
            if (changedSourceFiles.isEmpty()) continue;
            log.info((Object)("Changed source files detected, recompiling " + changedSourceFiles));
            try {
                this.compiler.compile(i.getSourcePath(), changedSourceFiles.stream().collect(Collectors.groupingBy(this::getFileExtension, Collectors.toSet())));
            }
            catch (Exception e) {
                DevModeMain.deploymentProblem = e;
                return false;
            }
        }
        for (DevModeContext.ModuleInfo i : this.context.getModules()) {
            if (i.getClassesPath() == null) continue;
            Stream<Path> classesStream = Files.walk(Paths.get(i.getClassesPath(), new String[0]), new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                if (!((Stream)classesStream.parallel()).anyMatch(p -> p.toString().endsWith(".class") && this.wasRecentlyModified((Path)p, i))) continue;
                this.lastChange = System.currentTimeMillis();
                boolean bl = true;
                return bl;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (classesStream == null) continue;
                if (throwable != null) {
                    try {
                        classesStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                classesStream.close();
            }
        }
        return false;
    }

    private Optional<String> matchingHandledExtension(Path p) {
        return this.compiler.allHandledExtensions().stream().filter(e -> p.toString().endsWith((String)e)).findFirst();
    }

    private String getFileExtension(File file) {
        String name = file.getName();
        int lastIndexOf = name.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return "";
        }
        return name.substring(lastIndexOf);
    }

    private boolean checkForConfigFileChange() {
        boolean configFilesHaveChanged = false;
        for (DevModeContext.ModuleInfo module : this.context.getModules()) {
            boolean doCopy = true;
            String rootPath = module.getResourcePath();
            if (rootPath == null) {
                rootPath = module.getClassesPath();
                doCopy = false;
            }
            if (rootPath == null) continue;
            Path root = Paths.get(rootPath, new String[0]);
            Path classesDir = Paths.get(module.getClassesPath(), new String[0]);
            for (String configFilePath : this.configFilePaths) {
                Path config = root.resolve(configFilePath);
                if (Files.exists(config, new LinkOption[0])) {
                    try {
                        Long existing;
                        long value = Files.getLastModifiedTime(config, new LinkOption[0]).toMillis();
                        if (value <= (existing = this.configFileTimestamps.get(config))) continue;
                        configFilesHaveChanged = true;
                        log.infof("Config file change detected: %s", (Object)config);
                        if (doCopy) {
                            Path target = classesDir.resolve(configFilePath);
                            byte[] data = CopyUtils.readFileContent(config);
                            try (FileOutputStream out = new FileOutputStream(target.toFile());){
                                out.write(data);
                            }
                        }
                        this.configFileTimestamps.put(config, value);
                        continue;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.configFileTimestamps.put(config, 0L);
                Path target = classesDir.resolve(configFilePath);
                try {
                    Files.deleteIfExists(target);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return configFilesHaveChanged;
    }

    private boolean wasRecentlyModified(Path p, DevModeContext.ModuleInfo module) {
        try {
            boolean recent;
            long sourceMod = Files.getLastModifiedTime(p, new LinkOption[0]).toMillis();
            boolean bl = recent = sourceMod > this.lastChange;
            if (recent) {
                return true;
            }
            if (module.getSourcePath() == null || module.getClassesPath() == null) {
                return false;
            }
            Path sourcesDir = Paths.get(module.getSourcePath(), new String[0]);
            Path classesDir = Paths.get(module.getClassesPath(), new String[0]);
            Optional<String> matchingExtension = this.matchingHandledExtension(p);
            if (matchingExtension.isPresent()) {
                String pathName = sourcesDir.relativize(p).toString();
                String classFileName = pathName.substring(0, pathName.length() - matchingExtension.get().length()) + ".class";
                Path classFile = classesDir.resolve(classFileName);
                if (!Files.exists(classFile, new LinkOption[0])) {
                    return true;
                }
                return sourceMod > Files.getLastModifiedTime(classFile, new LinkOption[0]).toMillis();
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RuntimeUpdatesProcessor setConfigFilePaths(Set<String> configFilePaths) {
        this.configFilePaths = configFilePaths;
        this.configFileTimestamps.clear();
        for (DevModeContext.ModuleInfo module : this.context.getModules()) {
            String rootPath = module.getResourcePath();
            if (rootPath == null) {
                rootPath = module.getClassesPath();
            }
            if (rootPath == null) continue;
            Path root = Paths.get(rootPath, new String[0]);
            for (String i : configFilePaths) {
                Path config = root.resolve(i);
                if (Files.exists(config, new LinkOption[0])) {
                    try {
                        this.configFileTimestamps.put(config, Files.getLastModifiedTime(config, new LinkOption[0]).toMillis());
                        continue;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.configFileTimestamps.put(config, 0L);
            }
        }
        return this;
    }
}

