/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DevModeContext
implements Serializable {
    private final List<URL> classPath = new ArrayList<URL>();
    private final List<ModuleInfo> modules = new ArrayList<ModuleInfo>();
    private final Map<String, String> systemProperties = new HashMap<String, String>();
    private final Map<String, String> buildSystemProperties = new HashMap<String, String>();

    public List<URL> getClassPath() {
        return this.classPath;
    }

    public List<ModuleInfo> getModules() {
        return this.modules;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public Map<String, String> getBuildSystemProperties() {
        return this.buildSystemProperties;
    }

    public static class ModuleInfo
    implements Serializable {
        private final String name;
        private final String projectDirectory;
        private final Set<String> sourcePaths;
        private final String classesPath;
        private final String resourcePath;

        public ModuleInfo(String name, String projectDirectory, Set<String> sourcePaths, String classesPath, String resourcePath) {
            this.name = name;
            this.projectDirectory = projectDirectory;
            this.sourcePaths = sourcePaths;
            this.classesPath = classesPath;
            this.resourcePath = resourcePath;
        }

        public String getName() {
            return this.name;
        }

        public String getProjectDirectory() {
            return this.projectDirectory;
        }

        public Set<String> getSourcePaths() {
            return this.sourcePaths;
        }

        public void addSourcePaths(Collection<String> additionalPaths) {
            additionalPaths.stream().map(p -> this.projectDirectory + File.separator + p).forEach(this.sourcePaths::add);
        }

        public String getClassesPath() {
            return this.classesPath;
        }

        public String getResourcePath() {
            return this.resourcePath;
        }
    }
}

