/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev;

import io.quarkus.bootstrap.app.AdditionalDependency;
import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.RunningQuarkusApplication;
import io.quarkus.bootstrap.app.StartupAction;
import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.builditem.ApplicationClassPredicateBuildItem;
import io.quarkus.dev.ClassLoaderCompiler;
import io.quarkus.dev.CompilationProvider;
import io.quarkus.dev.DevModeContext;
import io.quarkus.dev.DevModeMain;
import io.quarkus.dev.RuntimeUpdatesProcessor;
import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.dev.spi.HotReplacementSetup;
import io.quarkus.runner.bootstrap.AugmentActionImpl;
import io.quarkus.runtime.Timing;
import io.quarkus.runtime.configuration.QuarkusConfigFactory;
import io.quarkus.runtime.logging.InitialConfigurator;
import io.quarkus.runtime.logging.LoggingSetupRecorder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.logging.Logger;

public class IsolatedDevModeMain
implements BiConsumer<CuratedApplication, Map<String, Object>>,
Closeable {
    private static final Logger log = Logger.getLogger(DevModeMain.class);
    private DevModeContext context;
    private final List<HotReplacementSetup> hotReplacementSetups = new ArrayList<HotReplacementSetup>();
    private static volatile RunningQuarkusApplication runner;
    static volatile Throwable deploymentProblem;
    static volatile Throwable compileProblem;
    static volatile RuntimeUpdatesProcessor runtimeUpdatesProcessor;
    private static volatile CuratedApplication curatedApplication;
    private static volatile AugmentAction augmentAction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void firstStart() {
        block9: {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    StartupAction start = augmentAction.createInitialRuntimeApplication();
                    runner = start.run(new String[0]);
                }
                catch (Throwable t) {
                    deploymentProblem = t;
                    if (this.context.isAbortOnFailedStart()) {
                        log.error((Object)"Failed to start quarkus", t);
                        break block9;
                    }
                    log.error((Object)"Failed to start Quarkus", t);
                    log.info((Object)"Attempting to start hot replacement endpoint to recover from previous Quarkus startup failure");
                    if (runtimeUpdatesProcessor == null) break block9;
                    Thread.currentThread().setContextClassLoader((ClassLoader)curatedApplication.getBaseRuntimeClassLoader());
                    try {
                        if (!InitialConfigurator.DELAYED_HANDLER.isActivated()) {
                            Class<?> cl = Thread.currentThread().getContextClassLoader().loadClass(LoggingSetupRecorder.class.getName());
                            cl.getMethod("handleFailedStart", new Class[0]).invoke(null, new Object[0]);
                        }
                        runtimeUpdatesProcessor.startupFailed();
                    }
                    catch (Exception e) {
                        t.addSuppressed(new RuntimeException("Failed to recover after failed start", e));
                        throw new RuntimeException(t);
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void restartApp(Set<String> changedResources) {
        this.stop();
        Timing.restart((ClassLoader)curatedApplication.getAugmentClassLoader());
        deploymentProblem = null;
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            try {
                StartupAction start = augmentAction.reloadExistingApplication(changedResources);
                runner = start.run(new String[0]);
            }
            catch (Throwable t) {
                deploymentProblem = t;
                log.error((Object)"Failed to start quarkus", t);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private RuntimeUpdatesProcessor setupRuntimeCompilation(DevModeContext context, CuratedApplication application) throws Exception {
        if (!context.getModules().isEmpty()) {
            ClassLoaderCompiler compiler;
            ServiceLoader<CompilationProvider> serviceLoader = ServiceLoader.load(CompilationProvider.class);
            ArrayList<CompilationProvider> compilationProviders = new ArrayList<CompilationProvider>();
            for (CompilationProvider provider : serviceLoader) {
                compilationProviders.add(provider);
                context.getModules().forEach(moduleInfo -> moduleInfo.addSourcePaths(provider.handledSourcePaths()));
            }
            try {
                compiler = new ClassLoaderCompiler(Thread.currentThread().getContextClassLoader(), curatedApplication, compilationProviders, context);
            }
            catch (Exception e) {
                log.error((Object)"Failed to create compiler, runtime compilation will be unavailable", (Throwable)e);
                return null;
            }
            RuntimeUpdatesProcessor processor = new RuntimeUpdatesProcessor(context, compiler, this);
            for (HotReplacementSetup service : ServiceLoader.load(HotReplacementSetup.class, (ClassLoader)curatedApplication.getBaseRuntimeClassLoader())) {
                this.hotReplacementSetups.add(service);
                service.setupHotDeployment((HotReplacementContext)processor);
                processor.addHotReplacementSetup(service);
            }
            return processor;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ClassLoader old;
        if (runner != null) {
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(runner.getClassLoader());
            try {
                runner.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        QuarkusConfigFactory.setConfig(null);
        old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            ConfigProviderResolver cpr = ConfigProviderResolver.instance();
            cpr.releaseConfig(cpr.getConfig());
        }
        catch (Throwable throwable) {
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        runner = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.stop();
        }
        finally {
            try {
                for (HotReplacementSetup i : this.hotReplacementSetups) {
                    i.close();
                }
            }
            finally {
                curatedApplication.close();
            }
        }
    }

    @Override
    public void accept(CuratedApplication o, Map<String, Object> o2) {
        Timing.staticInitStarted((ClassLoader)o.getBaseRuntimeClassLoader());
        try {
            curatedApplication = o;
            Object potentialContext = o2.get(DevModeContext.class.getName());
            if (potentialContext instanceof DevModeContext) {
                this.context = (DevModeContext)potentialContext;
            } else {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ObjectOutputStream oo = new ObjectOutputStream(out);
                oo.writeObject(potentialContext);
                this.context = (DevModeContext)new ObjectInputStream(new ByteArrayInputStream(out.toByteArray())).readObject();
            }
            augmentAction = new AugmentActionImpl(curatedApplication, Collections.singletonList(new Consumer<BuildChainBuilder>(){

                @Override
                public void accept(BuildChainBuilder buildChainBuilder) {
                    buildChainBuilder.addBuildStep(new BuildStep(){

                        public void execute(BuildContext context) {
                            context.produce((BuildItem)new ApplicationClassPredicateBuildItem((Predicate)new Predicate<String>(){

                                @Override
                                public boolean test(String s) {
                                    for (AdditionalDependency i : curatedApplication.getQuarkusBootstrap().getAdditionalApplicationArchives()) {
                                        Path p;
                                        if (!i.isHotReloadable() || !Files.exists(p = i.getArchivePath().resolve(s.replace(".", "/") + ".class"), new LinkOption[0])) continue;
                                        return true;
                                    }
                                    return false;
                                }
                            }));
                        }
                    }).produces(ApplicationClassPredicateBuildItem.class).build();
                }
            }));
            runtimeUpdatesProcessor = this.setupRuntimeCompilation(this.context, o);
            if (runtimeUpdatesProcessor != null) {
                runtimeUpdatesProcessor.checkForFileChange();
                runtimeUpdatesProcessor.checkForChangedClasses();
            }
            this.firstStart();
            if ((deploymentProblem != null || compileProblem != null) && this.context.isAbortOnFailedStart()) {
                throw new RuntimeException(deploymentProblem == null ? compileProblem : deploymentProblem);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<DevModeMain> clazz = DevModeMain.class;
                    synchronized (DevModeMain.class) {
                        if (runner != null) {
                            try {
                                IsolatedDevModeMain.this.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, "Quarkus Shutdown Thread"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

