/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.common;

import io.quarkus.devservices.common.ContainerAddress;
import io.quarkus.runtime.util.StringUtil;
import java.util.Map;

public interface DatasourceServiceConfigurator {
    default public String getReactiveUrl(String jdbcUrl) {
        return jdbcUrl.replaceFirst("jdbc:", "vertx-reactive:");
    }

    default public String getJdbcUrl(ContainerAddress containerAddress, String databaseName) {
        return String.format("jdbc:%s://%s:%d/%s%s", this.getJdbcPrefix(), containerAddress.getHost(), containerAddress.getPort(), databaseName, this.getParameters(containerAddress.getRunningContainer().containerInfo().labels()));
    }

    public String getJdbcPrefix();

    default public String getParameters(Map<String, String> labels) {
        String parameters = labels.get("io.quarkus.devservices.compose.jdbc.parameters");
        return StringUtil.isNullOrEmpty((String)parameters) ? "" : "?" + parameters;
    }
}

