/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.db2.deployment;

import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProviderBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.testcontainers.containers.Db2Container;
import org.testcontainers.utility.DockerImageName;

public class DB2DevServicesProcessor {
    public static final String TAG = "11.5.5.1";

    @BuildStep
    DevServicesDatasourceProviderBuildItem setupDB2() {
        return new DevServicesDatasourceProviderBuildItem("db2", new DevServicesDatasourceProvider(){

            public DevServicesDatasourceProvider.RunningDevServicesDatasource startDatabase(Optional<String> username, Optional<String> password, Optional<String> datasourceName, Optional<String> imageName, Map<String, String> additionalProperties, final OptionalInt fixedExposedPort, LaunchMode launchMode) {
                final Db2Container container = new Db2Container(DockerImageName.parse((String)imageName.orElse("ibmcom/db2:11.5.5.1")).asCompatibleSubstituteFor(DockerImageName.parse((String)"ibmcom/db2"))){

                    protected void configure() {
                        super.configure();
                        if (fixedExposedPort.isPresent()) {
                            this.addFixedExposedPort(fixedExposedPort.getAsInt(), 50000);
                        }
                    }
                }.withPassword(password.orElse("quarkus")).withUsername(username.orElse("quarkus")).withDatabaseName(datasourceName.orElse("default"));
                additionalProperties.forEach((arg_0, arg_1) -> ((Db2Container)container).withUrlParam(arg_0, arg_1));
                container.start();
                return new DevServicesDatasourceProvider.RunningDevServicesDatasource(container.getJdbcUrl(), container.getUsername(), container.getPassword(), new Closeable(){

                    @Override
                    public void close() throws IOException {
                        container.stop();
                    }
                });
            }
        });
    }
}

