/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.db2.deployment;

import io.quarkus.datasource.deployment.spi.DevServicesDatasourceContainerConfig;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProviderBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerShutdownCloseable;
import io.quarkus.devservices.common.Labels;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.jboss.logging.Logger;
import org.testcontainers.containers.Db2Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class DB2DevServicesProcessor {
    private static final Logger LOG = Logger.getLogger(DB2DevServicesProcessor.class);

    @BuildStep
    DevServicesDatasourceProviderBuildItem setupDB2(final List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem) {
        return new DevServicesDatasourceProviderBuildItem("db2", new DevServicesDatasourceProvider(){

            public DevServicesDatasourceProvider.RunningDevServicesDatasource startDatabase(Optional<String> username, Optional<String> password, Optional<String> datasourceName, DevServicesDatasourceContainerConfig containerConfig, LaunchMode launchMode, Optional<Duration> startupTimeout) {
                QuarkusDb2Container container = new QuarkusDb2Container(containerConfig.getImageName(), containerConfig.getFixedExposedPort(), !devServicesSharedNetworkBuildItem.isEmpty());
                startupTimeout.ifPresent(arg_0 -> ((QuarkusDb2Container)container).withStartupTimeout(arg_0));
                String effectiveUsername = containerConfig.getUsername().orElse(username.orElse("quarkus"));
                String effectivePassword = containerConfig.getPassword().orElse(password.orElse("quarkus"));
                String effectiveDbName = containerConfig.getDbName().orElse(datasourceName.orElse("quarkus"));
                container.withUsername(effectiveUsername).withPassword(effectivePassword).withDatabaseName(effectiveDbName).withReuse(true);
                Labels.addDataSourceLabel((GenericContainer)container, datasourceName);
                containerConfig.getAdditionalJdbcUrlProperties().forEach((arg_0, arg_1) -> ((QuarkusDb2Container)container).withUrlParam(arg_0, arg_1));
                containerConfig.getCommand().ifPresent(arg_0 -> ((QuarkusDb2Container)container).setCommand(arg_0));
                containerConfig.getInitScriptPath().ifPresent(arg_0 -> ((QuarkusDb2Container)container).withInitScript(arg_0));
                container.start();
                LOG.info((Object)"Dev Services for IBM Db2 started.");
                return new DevServicesDatasourceProvider.RunningDevServicesDatasource(container.getContainerId(), container.getEffectiveJdbcUrl(), container.getReactiveUrl(), container.getUsername(), container.getPassword(), (Closeable)new ContainerShutdownCloseable((GenericContainer)container, "IBM Db2"));
            }
        });
    }

    private static class QuarkusDb2Container
    extends Db2Container {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private String hostName = null;

        public QuarkusDb2Container(Optional<String> imageName, OptionalInt fixedExposedPort, boolean useSharedNetwork) {
            super(DockerImageName.parse((String)imageName.orElseGet(() -> ConfigureUtil.getDefaultImageNameFor((String)"db2"))).asCompatibleSubstituteFor(DockerImageName.parse((String)"ibmcom/db2")));
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"db2");
                return;
            }
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 50000);
            } else {
                this.addExposedPorts(new int[]{50000});
            }
        }

        public String getEffectiveJdbcUrl() {
            if (this.useSharedNetwork) {
                String additionalUrlParams = this.constructUrlParameters(":", ";", ";");
                return "jdbc:db2://" + this.hostName + ":50000/" + this.getDatabaseName() + additionalUrlParams;
            }
            return super.getJdbcUrl();
        }

        public String getReactiveUrl() {
            return this.getEffectiveJdbcUrl().replaceFirst("jdbc:", "vertx-reactive:");
        }
    }
}

