/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.deployment;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.LogContainerCmd;
import io.quarkus.deployment.dev.devservices.DevServiceDescriptionBuildItem;
import io.quarkus.devservices.deployment.DevServicesCommand;
import java.io.IOException;
import java.util.Optional;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.output.FrameConsumerResultCallback;
import org.testcontainers.containers.output.OutputFrame;

@CommandDefinition(name="logs", description="Print container logs")
public class DevServicesLogsCommand
implements Command {
    @Argument(required=true, description="Dev Service name", completer=DevServicesCommand.DevServiceCompleter.class)
    private String devService;
    @Option(name="follow", shortName=102, description="Follow container logs", hasValue=false, defaultValue={"false"})
    private boolean follow;
    @Option(name="tail", shortName=116, description="Tail container logs", defaultValue={"-1"})
    private int tail;

    public CommandResult execute(CommandInvocation commandInvocation) {
        Optional<DevServiceDescriptionBuildItem> devService = DevServicesCommand.findDevService(this.devService);
        if (devService.isPresent()) {
            DevServiceDescriptionBuildItem desc = devService.get();
            try (FrameConsumerResultCallback resultCallback = new FrameConsumerResultCallback();){
                resultCallback.addConsumer(OutputFrame.OutputType.STDERR, frame -> commandInvocation.print(frame.getUtf8String()));
                resultCallback.addConsumer(OutputFrame.OutputType.STDOUT, frame -> commandInvocation.print(frame.getUtf8String()));
                LogContainerCmd logCmd = DockerClientFactory.lazyClient().logContainerCmd(desc.getContainerInfo().getId()).withFollowStream(Boolean.valueOf(this.follow)).withTail(Integer.valueOf(this.tail)).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true));
                logCmd.exec((ResultCallback)resultCallback);
                if (this.follow) {
                    commandInvocation.inputLine();
                } else {
                    resultCallback.awaitCompletion();
                }
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
            return CommandResult.SUCCESS;
        }
        commandInvocation.println("Could not find dev service with name " + this.devService);
        return CommandResult.FAILURE;
    }
}

